/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.i18n.ResourceHelper;

public class BundleTag
extends TagSupport {
    public static final String LOCALE_SESSION_KEY_PREFIX = "org.apache.taglibs.i18n.BundleTag.Locale:";
    private String baseName = null;
    private Locale locale = null;

    public void setBaseName(String baseName) {
        this.baseName = baseName;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocaleAttribute(String attribute) {
        this.locale = (Locale)this.pageContext.findAttribute(attribute);
    }

    public int doStartTag() throws JspException {
        ResourceBundle bundle = null;
        if (this.baseName == null) {
            throw new JspException("A baseName must be specified.");
        }
        if (this.locale == null) {
            this.locale = BundleTag.getLocale(this.pageContext, this.baseName);
        }
        if (this.locale != null) {
            bundle = ResourceBundle.getBundle(this.baseName, this.locale);
        } else {
            Enumeration localeEnumerator = this.pageContext.getRequest().getLocales();
            while (localeEnumerator.hasMoreElements()) {
                this.locale = (Locale)localeEnumerator.nextElement();
                ResourceBundle test = ResourceBundle.getBundle(this.baseName, this.locale);
                String language = test.getLocale().getLanguage();
                String country = test.getLocale().getCountry();
                if (test.getLocale().equals(this.locale)) {
                    bundle = test;
                    break;
                }
                if (this.locale.getLanguage().equals(language)) {
                    if (this.locale.getCountry().equals(country)) {
                        bundle = test;
                        continue;
                    }
                    if (bundle != null) continue;
                    bundle = test;
                    continue;
                }
                ServletContext sc = this.pageContext.getServletContext();
                sc.log("i18n: requested locale not available: " + this.locale);
            }
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(this.baseName);
            }
            BundleTag.setLocale(this.pageContext, this.baseName, bundle.getLocale());
        }
        ResourceBundle firstBundle = ResourceHelper.getBundle(this.pageContext);
        if (firstBundle != null) {
            String exp;
            String got = firstBundle.getLocale().getLanguage();
            if (!got.equals(exp = bundle.getLocale().getLanguage())) {
                throw new JspException("Locale language mismatch: '" + this.baseName + "'" + " got: '" + got + "'" + " expected: '" + exp + "'");
            }
        } else {
            ResourceHelper.setBundle(this.pageContext, bundle);
        }
        this.pageContext.getResponse().setLocale(bundle.getLocale());
        String id = this.getId();
        if (id != null) {
            this.pageContext.setAttribute(id, (Object)bundle, 1);
        }
        return 0;
    }

    public static Locale getLocale(PageContext pageContext, String baseName) {
        String key = LOCALE_SESSION_KEY_PREFIX + baseName;
        HttpSession session = pageContext.getSession();
        return (Locale)session.getAttribute(key);
    }

    public static void setLocale(PageContext pageContext, String baseName, Locale locale) {
        String key = LOCALE_SESSION_KEY_PREFIX + baseName;
        HttpSession session = pageContext.getSession();
        session.setAttribute(key, (Object)locale);
    }
}

