/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.TagSupport;

public class LocaleTag
extends TagSupport {
    private Locale locale;
    private String language;
    private String country;
    private String variant;

    public int doStartTag() throws JspException {
        return 1;
    }

    public void release() {
        super.release();
        this.locale = null;
        this.language = null;
        this.country = null;
        this.variant = null;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = this.createLocale();
        }
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getVariant() {
        return this.variant;
    }

    public void setVariant(String variant) {
        this.variant = variant;
    }

    protected Locale createLocale() {
        if (this.language != null && this.country != null) {
            return this.variant != null ? new Locale(this.language, this.country, this.variant) : new Locale(this.language, this.country);
        }
        return LocaleTag.getLocale(this.pageContext);
    }

    protected static Locale getLocale(PageContext pageContext) {
        ServletRequest request;
        Locale answer = pageContext.getResponse().getLocale();
        if (answer == null && (answer = (request = pageContext.getRequest()).getLocale()) == null) {
            Enumeration enumeration = request.getLocales();
            while (enumeration.hasMoreElements()) {
                answer = (Locale)enumeration.nextElement();
                if (answer != null) break;
            }
            if (answer == null) {
                answer = Locale.getDefault();
            }
        }
        return answer;
    }
}

