/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.i18n;

import java.io.IOException;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.taglibs.i18n.ResourceHelper;

public class MessageTag
extends BodyTagSupport {
    private String _key = null;
    private String _value = null;
    private ResourceBundle _bundle = null;
    private final MessageFormat _messageFormat = new MessageFormat("");
    private final List _arguments = new ArrayList();

    public void setKey(String key) {
        this._key = key;
    }

    public String getKey() {
        return this._key;
    }

    public void setBundleRef(String varName) {
        this._bundle = (ResourceBundle)((TagSupport)this).pageContext.getAttribute(varName);
    }

    public void setBundle(ResourceBundle aBundle) {
        this._bundle = aBundle;
    }

    public ResourceBundle getBundle() {
        if (this._bundle == null) {
            this._bundle = ResourceHelper.getBundle(((TagSupport)this).pageContext);
        }
        return this._bundle;
    }

    public void addArg(Object arg) {
        this._arguments.add(arg);
    }

    public void setArgs(Object[] args) {
        this._arguments.addAll(Arrays.asList(args));
    }

    public void release() {
        super.release();
        this._arguments.clear();
        this._key = null;
        this._value = null;
        this._bundle = null;
    }

    public int doStartTag() throws JspException {
        String key = this.getKey();
        ResourceBundle bundle = this.getBundle();
        if (key == null) {
            throw new JspException("MessageTag requires a key.");
        }
        if (bundle == null) {
            throw new JspException("A bundle must be defined by the BundleTag prior to using a MessageTag.");
        }
        try {
            this._value = bundle.getString(key);
        }
        catch (MissingResourceException e) {
            ServletContext sc = ((TagSupport)this).pageContext.getServletContext();
            sc.log("value not found for key:" + key);
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        try {
            if (this._value != null) {
                if (this._arguments != null) {
                    this._messageFormat.setLocale(this._bundle.getLocale());
                    this._messageFormat.applyPattern(this._value);
                    this._value = this._messageFormat.format(this._arguments.toArray());
                }
                ((TagSupport)this).pageContext.getOut().print(this._value);
            } else if (this.bodyContent != null) {
                this.bodyContent.writeOut((Writer)this.bodyContent.getEnclosingWriter());
            }
        }
        catch (IOException e) {
            throw new JspException("IO Error: " + e.getMessage());
        }
        return 6;
    }
}

