/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.afmtypes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pdfbox.afmtypes.CharMetric;
import org.pdfbox.afmtypes.Composite;
import org.pdfbox.afmtypes.KernPair;
import org.pdfbox.afmtypes.TrackKern;
import org.pdfbox.util.BoundingBox;

public class FontMetric {
    private float afmVersion;
    private int metricSets = 0;
    private String fontName;
    private String fullName;
    private String familyName;
    private String weight;
    private BoundingBox fontBBox;
    private String fontVersion;
    private String notice;
    private String encodingScheme;
    private int mappingScheme;
    private int escChar;
    private String characterSet;
    private int characters;
    private boolean isBaseFont;
    private float[] vVector;
    private boolean isFixedV;
    private float capHeight;
    private float xHeight;
    private float ascender;
    private float descender;
    private List comments = new ArrayList();
    private float underlinePosition;
    private float underlineThickness;
    private float italicAngle;
    private float[] charWidth;
    private boolean isFixedPitch;
    private float standardHorizontalWidth;
    private float standardVerticalWidth;
    private List charMetrics = new ArrayList();
    private Map charMetricsMap = new HashMap();
    private List trackKern = new ArrayList();
    private List composites = new ArrayList();
    private List kernPairs = new ArrayList();
    private List kernPairs0 = new ArrayList();
    private List kernPairs1 = new ArrayList();

    public float getCharacterWidth(String name) throws IOException {
        float result = 0.0f;
        CharMetric metric = (CharMetric)this.charMetricsMap.get(name);
        if (metric != null) {
            result = metric.getWx();
        }
        return result;
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public List getComments() {
        return this.comments;
    }

    public float getAFMVersion() {
        return this.afmVersion;
    }

    public int getMetricSets() {
        return this.metricSets;
    }

    public void setAFMVersion(float afmVersionValue) {
        this.afmVersion = afmVersionValue;
    }

    public void setMetricSets(int metricSetsValue) {
        if (metricSetsValue < 0 || metricSetsValue > 2) {
            throw new RuntimeException("The metricSets attribute must be in the set {0,1,2} and not '" + metricSetsValue + "'");
        }
        this.metricSets = metricSetsValue;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getWeight() {
        return this.weight;
    }

    public void setWeight(String weight) {
        this.weight = weight;
    }

    public BoundingBox getFontBBox() {
        return this.fontBBox;
    }

    public void setFontBBox(BoundingBox fontBBox) {
        this.fontBBox = fontBBox;
    }

    public String getNotice() {
        return this.notice;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public String getEncodingScheme() {
        return this.encodingScheme;
    }

    public void setEncodingScheme(String encodingScheme) {
        this.encodingScheme = encodingScheme;
    }

    public int getMappingScheme() {
        return this.mappingScheme;
    }

    public void setMappingScheme(int mappingScheme) {
        this.mappingScheme = mappingScheme;
    }

    public int getEscChar() {
        return this.escChar;
    }

    public void setEscChar(int escChar) {
        this.escChar = escChar;
    }

    public String getCharacterSet() {
        return this.characterSet;
    }

    public void setCharacterSet(String characterSet) {
        this.characterSet = characterSet;
    }

    public int getCharacters() {
        return this.characters;
    }

    public void setCharacters(int characters) {
        this.characters = characters;
    }

    public boolean isIsBaseFont() {
        return this.isBaseFont;
    }

    public void setIsBaseFont(boolean isBaseFont) {
        this.isBaseFont = isBaseFont;
    }

    public float[] getVVector() {
        return this.vVector;
    }

    public void setVVector(float[] vVector) {
        this.vVector = vVector;
    }

    public boolean isIsFixedV() {
        return this.isFixedV;
    }

    public void setIsFixedV(boolean isFixedV) {
        this.isFixedV = isFixedV;
    }

    public float getCapHeight() {
        return this.capHeight;
    }

    public void setCapHeight(float capHeight) {
        this.capHeight = capHeight;
    }

    public float getXHeight() {
        return this.xHeight;
    }

    public void setXHeight(float xHeight) {
        this.xHeight = xHeight;
    }

    public float getAscender() {
        return this.ascender;
    }

    public void setAscender(float ascender) {
        this.ascender = ascender;
    }

    public float getDescender() {
        return this.descender;
    }

    public void setDescender(float descender) {
        this.descender = descender;
    }

    public String getFontVersion() {
        return this.fontVersion;
    }

    public void setFontVersion(String fontVersion) {
        this.fontVersion = fontVersion;
    }

    public float getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(float underlinePosition) {
        this.underlinePosition = underlinePosition;
    }

    public float getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(float underlineThickness) {
        this.underlineThickness = underlineThickness;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float italicAngle) {
        this.italicAngle = italicAngle;
    }

    public float[] getCharWidth() {
        return this.charWidth;
    }

    public void setCharWidth(float[] charWidth) {
        this.charWidth = charWidth;
    }

    public boolean isIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(boolean isFixedPitch) {
        this.isFixedPitch = isFixedPitch;
    }

    public List getCharMetrics() {
        return this.charMetrics;
    }

    public void setCharMetrics(List charMetrics) {
        this.charMetrics = charMetrics;
    }

    public void addCharMetric(CharMetric metric) {
        this.charMetrics.add(metric);
        this.charMetricsMap.put(metric.getName(), metric);
    }

    public List getTrackKern() {
        return this.trackKern;
    }

    public void setTrackKern(List trackKern) {
        this.trackKern = trackKern;
    }

    public void addTrackKern(TrackKern kern) {
        this.trackKern.add(kern);
    }

    public List getComposites() {
        return this.composites;
    }

    public void setComposites(List composites) {
        this.composites = composites;
    }

    public void addComposite(Composite composite) {
        this.composites.add(composite);
    }

    public List getKernPairs() {
        return this.kernPairs;
    }

    public void addKernPair(KernPair kernPair) {
        this.kernPairs.add(kernPair);
    }

    public void setKernPairs(List kernPairs) {
        this.kernPairs = kernPairs;
    }

    public List getKernPairs0() {
        return this.kernPairs0;
    }

    public void addKernPair0(KernPair kernPair) {
        this.kernPairs0.add(kernPair);
    }

    public void setKernPairs0(List kernPairs0) {
        this.kernPairs0 = kernPairs0;
    }

    public List getKernPairs1() {
        return this.kernPairs1;
    }

    public void addKernPair1(KernPair kernPair) {
        this.kernPairs1.add(kernPair);
    }

    public void setKernPairs1(List kernPairs1) {
        this.kernPairs1 = kernPairs1;
    }

    public float getStandardHorizontalWidth() {
        return this.standardHorizontalWidth;
    }

    public void setStandardHorizontalWidth(float standardHorizontalWidth) {
        this.standardHorizontalWidth = standardHorizontalWidth;
    }

    public float getStandardVerticalWidth() {
        return this.standardVerticalWidth;
    }

    public void setStandardVerticalWidth(float standardVerticalWidth) {
        this.standardVerticalWidth = standardVerticalWidth;
    }
}

