/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cmapparser;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import org.pdfbox.cmaptypes.CMap;
import org.pdfbox.cmaptypes.CodespaceRange;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdfparser.PDFStreamParser;
import org.pdfbox.util.PDFOperator;

public class CMapParser {
    private static final String BEGIN_CODESPACE_RANGE = "begincodespacerange";
    private static final String BEGIN_BASE_FONT_CHAR = "beginbfchar";
    private static final String BEGIN_BASE_FONT_RANGE = "beginbfrange";
    private InputStream input;
    private CMap result;
    private RandomAccessFile file;

    public CMapParser(InputStream in, RandomAccessFile raf) {
        this.input = in;
        this.file = raf;
    }

    public CMap getResult() {
        return this.result;
    }

    public void parse() throws IOException {
        this.result = new CMap();
        PDFStreamParser parser = new PDFStreamParser(this.input, this.file);
        parser.parse();
        List tokens = parser.getTokens();
        int i = 0;
        while (i < tokens.size()) {
            Object token = tokens.get(i);
            if (token instanceof PDFOperator) {
                int j;
                COSNumber cosCount;
                PDFOperator op = (PDFOperator)token;
                if (op.getOperation().equals(BEGIN_CODESPACE_RANGE)) {
                    cosCount = (COSNumber)tokens.get(i - 1);
                    j = 0;
                    while (j < cosCount.intValue()) {
                        COSString startRange = (COSString)tokens.get(++i);
                        COSString endRange = (COSString)tokens.get(++i);
                        CodespaceRange range = new CodespaceRange();
                        range.setStart(startRange.getBytes());
                        range.setEnd(endRange.getBytes());
                        this.result.addCodespaceRange(range);
                        ++j;
                    }
                } else if (op.getOperation().equals(BEGIN_BASE_FONT_CHAR)) {
                    cosCount = (COSNumber)tokens.get(i - 1);
                    j = 0;
                    while (j < cosCount.intValue()) {
                        Object nextToken;
                        COSString inputCode = (COSString)tokens.get(++i);
                        if ((nextToken = tokens.get(++i)) instanceof COSString) {
                            String value = new String(((COSString)nextToken).getBytes(), "UTF-16BE");
                            this.result.addMapping(inputCode.getBytes(), value);
                        } else if (nextToken instanceof COSName) {
                            this.result.addMapping(inputCode.getBytes(), ((COSName)nextToken).getName());
                        } else {
                            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + nextToken);
                        }
                        ++j;
                    }
                } else if (op.getOperation().equals(BEGIN_BASE_FONT_RANGE)) {
                    cosCount = (COSNumber)tokens.get(i - 1);
                    j = 0;
                    while (j < cosCount.intValue()) {
                        COSString startCode = (COSString)tokens.get(++i);
                        COSString endCode = (COSString)tokens.get(++i);
                        Object nextToken = tokens.get(++i);
                        byte[] startBytes = startCode.getBytes();
                        byte[] endBytes = endCode.getBytes();
                        byte[] tokenBytes = ((COSString)nextToken).getBytes();
                        String value = null;
                        while (!this.equals(startBytes, endBytes)) {
                            value = new String(tokenBytes, "UTF-16BE");
                            this.result.addMapping(startBytes, value);
                            this.increment(startBytes);
                            this.increment(tokenBytes);
                        }
                        value = new String(tokenBytes, "UTF-16BE");
                        this.result.addMapping(startBytes, value);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private String getHexString(byte[] data) {
        String finalResult = "";
        int i = 0;
        while (i < data.length) {
            int intValue = (data[i] + 256) % 256;
            if (intValue < 10) {
                finalResult = finalResult + "0";
            }
            finalResult = finalResult + Integer.toHexString(intValue);
            ++i;
        }
        return finalResult;
    }

    private void increment(byte[] data) {
        this.increment(data, data.length - 1);
    }

    private void increment(byte[] data, int position) {
        if (position > 0 && data[position] == 255) {
            data[position] = 0;
            this.increment(data, position - 1);
        } else {
            data[position] = (byte)(data[position] + 1);
        }
    }

    private boolean equals(byte[] first, byte[] second) {
        boolean equals = true;
        int i = 0;
        while (i < first.length) {
            if (first[i] != second[i]) {
                equals = false;
            }
            ++i;
        }
        return equals;
    }
}

