/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSDocument;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.COSStream;
import org.pdfbox.cos.COSString;
import org.pdfbox.encryption.PDFEncryption;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;

public class DecryptDocument {
    private static final COSName ENCRYPT = COSName.getPDFName("Encrypt");
    private PDDocument pdDocument = null;
    private COSDocument document;
    private byte[] encryptionKey = null;
    private PDFEncryption encryption = new PDFEncryption();

    public DecryptDocument(PDDocument doc) {
        this.pdDocument = doc;
        this.document = doc.getDocument();
    }

    public DecryptDocument(COSDocument doc) {
        this.pdDocument = new PDDocument(doc);
        this.document = doc;
    }

    public void decryptDocument(String password) throws CryptographyException, IOException, InvalidPasswordException {
        long start = System.currentTimeMillis();
        COSDictionary trailer = this.document.getTrailer();
        COSDictionary encryptedDictionary = (COSDictionary)trailer.getDictionaryObject(ENCRYPT);
        long permissions = ((COSNumber)encryptedDictionary.getDictionaryObject(COSName.getPDFName("P"))).intValue();
        long revision = ((COSNumber)encryptedDictionary.getDictionaryObject(COSName.getPDFName("R"))).intValue();
        COSNumber cosLength = (COSNumber)encryptedDictionary.getDictionaryObject(COSName.getPDFName("Length"));
        long length = 5L;
        if (cosLength != null) {
            length = cosLength.intValue() / 8;
        }
        COSString id = (COSString)this.document.getDocumentID().get(0);
        COSString userPassword = (COSString)encryptedDictionary.getDictionaryObject(COSName.getPDFName("U"));
        COSString ownerPassword = (COSString)encryptedDictionary.getDictionaryObject(COSName.getPDFName("O"));
        boolean isUserPassword = this.encryption.isUserPassword(password.getBytes(), userPassword.getBytes(), ownerPassword.getBytes(), permissions, id.getBytes(), revision, length);
        boolean isOwnerPassword = this.encryption.isOwnerPassword(password.getBytes(), userPassword.getBytes(), ownerPassword.getBytes(), permissions, id.getBytes(), revision, length);
        if (isUserPassword) {
            this.encryptionKey = this.encryption.computeEncryptedKey(password.getBytes(), ownerPassword.getBytes(), permissions, id.getBytes(), revision, length);
        } else if (isOwnerPassword) {
            byte[] computedUserPassword = this.encryption.getUserPassword(password.getBytes(), ownerPassword.getBytes(), revision, length);
            this.encryptionKey = this.encryption.computeEncryptedKey(computedUserPassword, ownerPassword.getBytes(), permissions, id.getBytes(), revision, length);
        } else {
            throw new InvalidPasswordException("Error: The supplied password does not match either the owner or user password in the document.");
        }
        List allObjects = this.document.getObjects();
        Iterator objectIter = allObjects.iterator();
        while (objectIter.hasNext()) {
            this.decryptObject((COSObject)objectIter.next());
        }
        this.document.setOriginalEncryptionDictionary(encryptedDictionary);
        trailer.removeItem(ENCRYPT);
        long stop = System.currentTimeMillis();
    }

    private static void printHexString(byte[] data) {
        int i = 0;
        while (i < data.length) {
            int nextByte = (data[i] + 256) % 256;
            String hexString = Integer.toHexString(nextByte);
            if (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            System.out.print(hexString);
            if (i != 0 && (i + 1) % 2 == 0) {
                System.out.print(" ");
            } else if (i != 0 && i % 20 == 0) {
                System.out.println();
            }
            ++i;
        }
        System.out.println();
    }

    private void decryptObject(COSObject object) throws CryptographyException, IOException {
        long objNum = object.getObjectNumber().intValue();
        long genNum = object.getGenerationNumber().intValue();
        COSBase base = object.getObject();
        this.decrypt(base, objNum, genNum);
    }

    private void decrypt(Object obj, long objNum, long genNum) throws CryptographyException, IOException {
        if (obj instanceof COSString) {
            this.decryptString((COSString)obj, objNum, genNum);
        } else if (obj instanceof COSDictionary) {
            this.decryptDictionary((COSDictionary)obj, objNum, genNum);
        } else if (obj instanceof COSStream) {
            this.decryptStream((COSStream)obj, objNum, genNum);
        } else if (obj instanceof COSArray) {
            this.decryptArray((COSArray)obj, objNum, genNum);
        }
    }

    private void decryptStream(COSStream stream, long objNum, long genNum) throws CryptographyException, IOException {
        this.decryptDictionary(stream.getDictionary(), objNum, genNum);
        InputStream encryptedStream = stream.getFilteredStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, encryptedStream, stream.createFilteredStream());
    }

    private void decryptDictionary(COSDictionary dictionary, long objNum, long genNum) throws CryptographyException, IOException {
        Iterator values = dictionary.getValues().iterator();
        while (values.hasNext()) {
            this.decrypt(values.next(), objNum, genNum);
        }
    }

    private void decryptString(COSString string, long objNum, long genNum) throws CryptographyException, IOException {
        ByteArrayInputStream data = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.encryption.encryptData(objNum, genNum, this.encryptionKey, data, buffer);
        string.reset();
        string.append(buffer.toByteArray());
    }

    private void decryptArray(COSArray array, long objNum, long genNum) throws CryptographyException, IOException {
        int i = 0;
        while (i < array.size()) {
            this.decrypt(array.get(i), objNum, genNum);
            ++i;
        }
    }
}

