/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.io;

import java.io.IOException;
import java.io.InputStream;

public class NBitInputStream {
    private int bitsInChunk;
    private InputStream in;
    private int currentByte;
    private int bitsLeftInCurrentByte;

    public NBitInputStream(InputStream is) {
        this.in = is;
        this.bitsLeftInCurrentByte = 0;
        this.bitsInChunk = 8;
    }

    public void unread(long data) {
        this.currentByte = (int)((long)this.currentByte | (data <<= this.bitsLeftInCurrentByte));
        this.bitsLeftInCurrentByte += this.bitsInChunk;
    }

    public long read() throws IOException {
        long retval = 0L;
        int i = 0;
        while (i < this.bitsInChunk && retval != -1L) {
            if (this.bitsLeftInCurrentByte == 0) {
                this.currentByte = this.in.read();
                this.bitsLeftInCurrentByte = 8;
            }
            if (this.currentByte == -1) {
                retval = -1L;
            } else {
                retval <<= 1;
                retval |= (long)(this.currentByte >> this.bitsLeftInCurrentByte - 1 & 1);
                --this.bitsLeftInCurrentByte;
            }
            ++i;
        }
        return retval;
    }

    public int getBitsInChunk() {
        return this.bitsInChunk;
    }

    public void setBitsInChunk(int bitsInChunk) {
        this.bitsInChunk = bitsInChunk;
    }
}

