/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSString;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.PDPageNode;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class PDDocumentCatalog {
    private COSDictionary root;
    private PDDocument document;
    private PDAcroForm acroForm = null;

    public PDDocumentCatalog(PDDocument doc) {
        this.document = doc;
        this.root = new COSDictionary();
        this.root.setItem(COSName.TYPE, new COSString("Catalog"));
        this.document.getDocument().getTrailer().setItem(COSName.ROOT, this.root);
    }

    public PDDocumentCatalog(PDDocument doc, COSDictionary rootDictionary) {
        this.document = doc;
        this.root = rootDictionary;
    }

    public PDAcroForm getAcroForm() {
        if (this.acroForm == null) {
            COSDictionary acroFormDic = (COSDictionary)this.root.getDictionaryObject(COSName.ACRO_FORM);
            if (acroFormDic == null) {
                this.acroForm = new PDAcroForm(this.document);
                this.root.setItem(COSName.ACRO_FORM, this.acroForm.getDictionary());
            } else {
                this.acroForm = new PDAcroForm(this.document, acroFormDic);
            }
        }
        return this.acroForm;
    }

    public PDPageNode getPages() {
        return new PDPageNode((COSDictionary)this.root.getDictionaryObject(COSName.PAGES));
    }

    public List getAllPages() {
        ArrayList retval = new ArrayList();
        PDPageNode rootNode = this.getPages();
        this.getPageObjects(rootNode, retval);
        return retval;
    }

    private void getPageObjects(PDPageNode node, List list) {
        List kids = node.getKids();
        Iterator kidIter = kids.iterator();
        while (kidIter.hasNext()) {
            Object next = kidIter.next();
            if (next instanceof PDPage) {
                list.add(next);
                continue;
            }
            PDPageNode nextNode = (PDPageNode)next;
            this.getPageObjects(nextNode, list);
        }
    }
}

