/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;

public class PDExtGState {
    private static final COSName LW = COSName.getPDFName("LW");
    private static final COSName LC = COSName.getPDFName("LC");
    private static final COSName LJ = COSName.getPDFName("LJ");
    private COSDictionary resources;

    public PDExtGState(COSDictionary state) {
        this.resources = state;
    }

    public PDExtGState() {
        this.resources = new COSDictionary();
        this.resources.setItem(COSName.TYPE, COSName.getPDFName("ExtGState"));
    }

    public Float getLineWidth() {
        return this.getFloatItem(LW);
    }

    public void setLineWidth(Float width) {
        this.setFloatItem(LW, width);
    }

    public Long getLineCapStyle() {
        return this.getLongItem(LC);
    }

    public void setLineCapStyle(Long style) {
        this.setLongItem(LC, style);
    }

    public Long getLineJoinStyle() {
        return this.getLongItem(LJ);
    }

    public void setLineJoinStyle(Long style) {
        this.setLongItem(LJ, style);
    }

    private Float getFloatItem(COSName key) {
        Float retval = null;
        COSNumber value = (COSNumber)this.resources.getDictionaryObject(key);
        if (value != null) {
            retval = new Float(value.floatValue());
        }
        return retval;
    }

    private void setFloatItem(COSName key, Float value) {
        if (value == null) {
            this.resources.removeItem(key);
        } else {
            this.resources.setItem(key, new COSFloat(value.floatValue()));
        }
    }

    private Long getLongItem(COSName key) {
        Long retval = null;
        COSNumber value = (COSNumber)this.resources.getDictionaryObject(key);
        if (value != null) {
            retval = new Long(value.intValue());
        }
        return retval;
    }

    private void setLongItem(COSName key, Long value) {
        if (value == null) {
            this.resources.removeItem(key);
        } else {
            this.resources.setItem(key, new COSInteger(value));
        }
    }
}

