/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.pdmodel.common.COSDictionaryMap;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDFontFactory;

public class PDResources {
    private COSDictionary resources;

    public PDResources() {
        this.resources = new COSDictionary();
    }

    public PDResources(COSDictionary resourceDictionary) {
        this.resources = resourceDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.resources;
    }

    public Map getFonts() throws IOException {
        COSDictionaryMap retval = null;
        COSDictionary fonts = (COSDictionary)this.resources.getDictionaryObject(COSName.FONT);
        if (fonts != null) {
            HashMap<COSName, PDFont> actuals = new HashMap<COSName, PDFont>();
            retval = new COSDictionaryMap(actuals, fonts);
            Iterator fontNames = fonts.keyList().iterator();
            while (fontNames.hasNext()) {
                COSName fontName = (COSName)fontNames.next();
                COSDictionary fontDictionary = (COSDictionary)fonts.getDictionaryObject(fontName);
                actuals.put(fontName, PDFontFactory.createFont(fontDictionary));
            }
        }
        return retval;
    }

    public void setFonts(Map fonts) {
        Iterator iter = fonts.keySet().iterator();
        COSDictionary dic = new COSDictionary();
        while (iter.hasNext()) {
            COSName name = (COSName)iter.next();
            PDFont font = (PDFont)fonts.get(name);
            dic.setItem(name, font.getCOSObject());
        }
    }
}

