/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import org.apache.commons.httpclient.Base64;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

class Authenticator {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.Authenticator");
    private static Base64 base64 = new Base64();

    Authenticator() {
    }

    static boolean authenticate(HttpMethod method, HttpState state) throws HttpException {
        log.debug("Authenticator.authenticate(HttpMethod, HttpState)");
        Header challengeHeader = method.getResponseHeader("WWW-Authenticate");
        if (null == challengeHeader) {
            return false;
        }
        String challenge = challengeHeader.getValue();
        if (null == challenge) {
            return false;
        }
        int space = challenge.indexOf(32);
        if (space < 0) {
            throw new HttpException("Unable to parse authentication challenge \"" + challenge + "\", expected space");
        }
        String authScheme = challenge.substring(0, space);
        if ("basic".equalsIgnoreCase(authScheme)) {
            if (challenge.length() < space + 1) {
                throw new HttpException("Unable to parse authentication challenge \"" + challenge + "\", expected realm");
            }
            String realmstr = challenge.substring(space + 1, challenge.length());
            realmstr.trim();
            if (realmstr.length() < "realm=\"\"".length()) {
                throw new HttpException("Unable to parse authentication challenge \"" + challenge + "\", expected realm");
            }
            String realm = realmstr.substring("realm=\"".length(), realmstr.length() - 1);
            log.debug("Parsed realm \"" + realm + "\" from challenge \"" + challenge + "\".");
            Header header = Authenticator.basic(realm, state);
            if (null != header) {
                method.addRequestHeader(header);
                return true;
            }
            return false;
        }
        if ("digest".equalsIgnoreCase(authScheme)) {
            throw new UnsupportedOperationException("Digest authentication is not supported.");
        }
        throw new UnsupportedOperationException("Authentication type \"" + authScheme + "\" is not recognized.");
    }

    static Header basic(String realm, HttpState state) throws HttpException {
        log.debug("Authenticator.basic(String,HttpState)");
        UsernamePasswordCredentials cred = null;
        try {
            cred = (UsernamePasswordCredentials)state.getCredentials(realm);
        }
        catch (ClassCastException e) {
            throw new HttpException("UsernamePasswordCredentials required for Basic authentication.");
        }
        if (null == cred) {
            if (log.isInfoEnabled()) {
                log.info("No credentials found for realm \"" + realm + "\", attempting to use default credentials.");
            }
            try {
                cred = (UsernamePasswordCredentials)state.getCredentials(null);
            }
            catch (ClassCastException e) {
                throw new HttpException("UsernamePasswordCredentials required for Basic authentication.");
            }
        }
        if (null == cred) {
            throw new HttpException("No credentials available for the Basic authentication realm \"" + realm + "\"/");
        }
        return new Header("Authorization", Authenticator.basic(cred));
    }

    static String basic(UsernamePasswordCredentials cred) throws HttpException {
        String authString = cred.getUserName() + ":" + cred.getPassword();
        return "Basic " + new String(Base64.encode(authString.getBytes()));
    }
}

