/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.log.Log;
import org.apache.commons.httpclient.log.LogSource;

public class GetMethod
extends HttpMethodBase {
    private static final Log log = LogSource.getInstance("org.apache.commons.httpclient.methods.GetMethod");
    private static final Log wireLog = LogSource.getInstance("httpclient.wire");
    private static final String TEMP_DIR = "temp/";
    protected boolean useDisk = false;
    protected byte[] memoryData;
    protected File fileData;
    protected String tempDir = "temp/";
    protected String tempFile = null;

    public GetMethod() {
        this.setFollowRedirects(true);
    }

    public GetMethod(String path) {
        super(path);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, String tempDir) {
        super(path);
        this.setUseDisk(true);
        this.setTempDir(tempDir);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, String tempDir, String tempFile) {
        super(path);
        this.setUseDisk(true);
        this.setTempDir(tempDir);
        this.setTempFile(tempFile);
        this.setFollowRedirects(true);
    }

    public GetMethod(String path, File fileData) {
        this(path);
        this.useDisk = true;
        this.fileData = fileData;
        this.setFollowRedirects(true);
    }

    public void setUseDisk(boolean useDisk) {
        this.checkNotUsed();
        this.useDisk = useDisk;
    }

    public boolean getUseDisk() {
        return this.useDisk;
    }

    public void setTempDir(String tempDir) {
        this.checkNotUsed();
        this.tempDir = tempDir;
        this.setUseDisk(true);
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempFile(String tempFile) {
        this.checkNotUsed();
        this.tempFile = tempFile;
    }

    public String getTempFile() {
        return this.tempFile;
    }

    public File getFileData() {
        return this.fileData;
    }

    public void setFileData(File fileData) {
        this.checkNotUsed();
        this.fileData = fileData;
    }

    public String getName() {
        return "GET";
    }

    public void recycle() {
        super.recycle();
        this.memoryData = null;
        this.fileData = null;
        this.setFollowRedirects(true);
    }

    public byte[] getResponseBody() {
        this.checkUsed();
        if (this.useDisk) {
            try {
                FileInputStream is = new FileInputStream(this.fileData);
                byte[] buffer = new byte[4096];
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                int nb = 0;
                while ((nb = ((InputStream)is).read(buffer)) != -1) {
                    os.write(buffer, 0, nb);
                }
                ((InputStream)is).close();
                return os.toByteArray();
            }
            catch (IOException e) {
                log.error("Exception in GetMethod.getResponseBody() while retrieving data from file \"" + this.fileData + "\".", e);
                return null;
            }
        }
        return this.memoryData;
    }

    public String getResponseBodyAsString() {
        byte[] data = this.getResponseBody();
        if (null == data) {
            return null;
        }
        return new String(data);
    }

    public InputStream getResponseBodyAsStream() throws IOException {
        this.checkUsed();
        if (this.useDisk) {
            return new FileInputStream(this.fileData);
        }
        if (null == this.memoryData) {
            return null;
        }
        return new ByteArrayInputStream(this.memoryData);
    }

    protected void readResponseBody(HttpState state, HttpConnection conn) throws IOException {
        log.debug("GetMethod.readResponseBody(HttpState,HttpConnection)");
        OutputStream out = null;
        if (this.useDisk) {
            if (this.fileData == null) {
                File dir = new File(this.tempDir);
                dir.deleteOnExit();
                dir.mkdirs();
                String tempFileName = null;
                if (this.tempFile == null) {
                    String encodedPath = URLEncoder.encode(this.getPath());
                    int length = encodedPath.length();
                    if (length > 200) {
                        encodedPath = encodedPath.substring(length - 190, length);
                    }
                    tempFileName = System.currentTimeMillis() + "-" + encodedPath + ".tmp";
                } else {
                    tempFileName = this.tempFile;
                }
                this.fileData = new File(this.tempDir, tempFileName);
                this.fileData.deleteOnExit();
            }
            out = new FileOutputStream(this.fileData);
        } else {
            out = new ByteArrayOutputStream();
        }
        this.readResponseBody(state, conn, out);
        if (!this.useDisk) {
            this.memoryData = ((ByteArrayOutputStream)out).toByteArray();
        }
        out.close();
    }
}

