--
-- Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
--
-- The contents of this file are subject to the CCM Public
-- License (the "License"); you may not use this file except in
-- compliance with the License. You may obtain a copy of the
-- License at http://www.redhat.com/licenses/ccmpl.html.
--
-- Software distributed under the License is distributed on an
-- "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
-- or implied. See the License for the specific language governing
-- rights and limitations under the License.
--
-- $Id: //core-platform/dev/sql/ccm-core/postgres/upgrade/5.2.1-6.0.0/drop-ri-triggers.sql#3 $
-- $DateTime: 2004/04/07 16:07:11 $

delete from pg_trigger
 where tgname in (select tgname
                    from pg_trigger,
                         pg_class a,
                         pg_class b
                   where tgisconstraint
                     and tgconstrrelid = a.oid
                     and tgrelid = b.oid
                     and a.relname in ('acs_auditing',
                                       'acs_objects',
                                       'acs_permissions',
                                       'acs_privileges',
                                       'acs_stylesheets',
                                       'acs_stylesheet_node_map',
                                       'acs_stylesheet_type_map',
                                       'apm_listeners',
                                       'apm_packages',
                                       'apm_package_types',
                                       'apm_package_type_listener_map',
                                       'applications',
                                       'application_types',
                                       'application_type_privilege_map',
                                       'bebop_components',
                                       'bebop_component_hierarchy',
                                       'bebop_form_process_listeners',
                                       'bebop_form_sections',
                                       'bebop_listeners',
                                       'bebop_listener_map',
                                       'bebop_meta_object',
                                       'bebop_object_type',
                                       'bebop_options',
                                       'bebop_process_listeners',
                                       'bebop_widgets',
                                       'cat_categories',
                                       'cat_category_category_map',
                                       'cat_category_purpose_map',
                                       'cat_cat_subcat_trans_index',
                                       'cat_object_category_map',
                                       'cat_object_root_category_map',
                                       'cat_purposes',
                                       'cat_root_cat_object_map',
                                       'cms_image_mime_types',
                                       'cms_mime_extensions',
                                       'cms_mime_status',
                                       'cms_mime_types',
                                       'cms_text_mime_types',
                                       'content_change_time',
                                       'cw_processes',
                                       'cw_process_definitions',
                                       'cw_system_tasks',
                                       'cw_tasks',
                                       'cw_task_comments',
                                       'cw_task_dependencies',
                                       'cw_task_group_assignees',
                                       'cw_task_listeners',
                                       'cw_task_user_assignees',
                                       'cw_user_tasks',
                                       'email_addresses',
                                       'forms_dataquery',
                                       'forms_dd_select',
                                       'forms_lstnr_conf_email',
                                       'forms_lstnr_conf_redirect',
                                       'forms_lstnr_simple_email',
                                       'forms_lstnr_tmpl_email',
                                       'forms_lstnr_xml_email',
                                       'forms_widget_label',
                                       'g11n_catalogs',
                                       'g11n_charsets',
                                       'g11n_locales',
                                       'g11n_locale_charset_map',
                                       'granted_context_non_leaf_map',
                                       'groups',
                                       'group_member_map',
                                       'group_member_trans_index',
                                       'group_subgroup_map',
                                       'group_subgroup_trans_index',
                                       'lucene_docs',
                                       'messages',
                                       'message_parts',
                                       'message_threads',
                                       'nt_digests',
                                       'nt_queue',
                                       'nt_requests',
                                       'object_container_map',
                                       'object_context',
                                       'object_context_map',
                                       'object_grants',
                                       'parameterized_privileges',
                                       'parties',
                                       'party_email_map',
                                       'persistence_dynamic_assoc',
                                       'persistence_dynamic_ot',
                                       'person_names',
                                       'portals',
                                       'portlets',
                                       'post_convert_html',
                                       'preferences',
                                       'pre_convert_html',
                                       'roles',
                                       'search_content',
                                       'search_indexing_jobs',
                                       'site_nodes',
                                       'ungranted_context_non_leaf_map',
                                       'users',
                                       'user_authentication',
                                       'vcx_blob_operations',
                                       'vcx_clob_operations',
                                       'vcx_event_types',
                                       'vcx_generic_operations',
                                       'vcx_java_classes',
                                       'vcx_obj_changes',
                                       'vcx_operations',
                                       'vcx_tags',
                                       'vcx_txns',
                                       'vc_actions',
                                       'vc_blob_operations',
                                       'vc_clob_operations',
                                       'vc_generic_operations',
                                       'vc_objects',
                                       'vc_operations',
                                       'vc_transactions',
                                       'web_hosts')
                     and b.relname in ('acs_auditing',
                                       'acs_objects',
                                       'acs_permissions',
                                       'acs_privileges',
                                       'acs_stylesheets',
                                       'acs_stylesheet_node_map',
                                       'acs_stylesheet_type_map',
                                       'apm_listeners',
                                       'apm_packages',
                                       'apm_package_types',
                                       'apm_package_type_listener_map',
                                       'applications',
                                       'application_types',
                                       'application_type_privilege_map',
                                       'bebop_components',
                                       'bebop_component_hierarchy',
                                       'bebop_form_process_listeners',
                                       'bebop_form_sections',
                                       'bebop_listeners',
                                       'bebop_listener_map',
                                       'bebop_meta_object',
                                       'bebop_object_type',
                                       'bebop_options',
                                       'bebop_process_listeners',
                                       'bebop_widgets',
                                       'cat_categories',
                                       'cat_category_category_map',
                                       'cat_category_purpose_map',
                                       'cat_cat_subcat_trans_index',
                                       'cat_object_category_map',
                                       'cat_object_root_category_map',
                                       'cat_purposes',
                                       'cat_root_cat_object_map',
                                       'cms_image_mime_types',
                                       'cms_mime_extensions',
                                       'cms_mime_status',
                                       'cms_mime_types',
                                       'cms_text_mime_types',
                                       'content_change_time',
                                       'cw_processes',
                                       'cw_process_definitions',
                                       'cw_system_tasks',
                                       'cw_tasks',
                                       'cw_task_comments',
                                       'cw_task_dependencies',
                                       'cw_task_group_assignees',
                                       'cw_task_listeners',
                                       'cw_task_user_assignees',
                                       'cw_user_tasks',
                                       'email_addresses',
                                       'forms_dataquery',
                                       'forms_dd_select',
                                       'forms_lstnr_conf_email',
                                       'forms_lstnr_conf_redirect',
                                       'forms_lstnr_simple_email',
                                       'forms_lstnr_tmpl_email',
                                       'forms_lstnr_xml_email',
                                       'forms_widget_label',
                                       'g11n_catalogs',
                                       'g11n_charsets',
                                       'g11n_locales',
                                       'g11n_locale_charset_map',
                                       'granted_context_non_leaf_map',
                                       'groups',
                                       'group_member_map',
                                       'group_member_trans_index',
                                       'group_subgroup_map',
                                       'group_subgroup_trans_index',
                                       'lucene_docs',
                                       'messages',
                                       'message_parts',
                                       'message_threads',
                                       'nt_digests',
                                       'nt_queue',
                                       'nt_requests',
                                       'object_container_map',
                                       'object_context',
                                       'object_context_map',
                                       'object_grants',
                                       'parameterized_privileges',
                                       'parties',
                                       'party_email_map',
                                       'persistence_dynamic_assoc',
                                       'persistence_dynamic_ot',
                                       'person_names',
                                       'portals',
                                       'portlets',
                                       'post_convert_html',
                                       'preferences',
                                       'pre_convert_html',
                                       'roles',
                                       'search_content',
                                       'search_indexing_jobs',
                                       'site_nodes',
                                       'ungranted_context_non_leaf_map',
                                       'users',
                                       'user_authentication',
                                       'vcx_blob_operations',
                                       'vcx_clob_operations',
                                       'vcx_event_types',
                                       'vcx_generic_operations',
                                       'vcx_java_classes',
                                       'vcx_obj_changes',
                                       'vcx_operations',
                                       'vcx_tags',
                                       'vcx_txns',
                                       'vc_actions',
                                       'vc_blob_operations',
                                       'vc_clob_operations',
                                       'vc_generic_operations',
                                       'vc_objects',
                                       'vc_operations',
                                       'vc_transactions',
                                       'web_hosts'));
update pg_class
   set reltriggers = (select count(*)
                        from pg_trigger t
                       where t.tgrelid = pg_class.oid)
 where relkind = 'r';
