<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" 
        xmlns:formbuilder="http://www.arsdigita.com/formbuilder/1.0"
        xmlns:bebop="http://www.arsdigita.com/bebop/1.0">

<!-- This contains text widgets such as textfield, password, and textarea -->

<!-- The standard password form -->
<xsl:template match="component[defaultDomainClass='com.arsdigita.formbuilder.PersistentPassword']">
   <th align="left" valign="top">
     <xsl:call-template name="printLabel"/>
   </th>
   <td align="left" valign="top">
     <xsl:call-template name="textFieldTemplate">
        <xsl:with-param name="type" select="'password'"/>
     </xsl:call-template>
     <xsl:call-template name="printErrors"/>
   </td>
</xsl:template>

<!-- The standard textField form -->
<xsl:template match="component[defaultDomainClass='com.arsdigita.formbuilder.PersistentTextField']">
   <th align="left" valign="top">
     <xsl:call-template name="printLabel"/>
   </th>
   <td align="left" valign="top">
   <xsl:call-template name="textFieldTemplate">
      <xsl:with-param name="type" select="'text'"/>
   </xsl:call-template>
     <xsl:call-template name="printErrors"/>
   </td>
</xsl:template>

<!-- a template for all of the single line text fields -->
<xsl:template name="textFieldTemplate">
  <xsl:param name="type"/>
  <input>
    <xsl:attribute name="type"><xsl:value-of select="$type"/></xsl:attribute>
    <xsl:attribute name="maxlength"><xsl:value-of select="maxlength"/></xsl:attribute>
    <xsl:attribute name="name"><xsl:value-of select="parameterName"/></xsl:attribute>
    <xsl:attribute name="size"><xsl:value-of select="size"/></xsl:attribute>
    <xsl:attribute name="value">
      <xsl:call-template name="printDefaultValue"/>
    </xsl:attribute>
  </input>
</xsl:template>


<!-- Persistent Text Area -->
<xsl:template match="component[defaultDomainClass='com.arsdigita.formbuilder.PersistentTextArea']">
   <th align="left" valign="top">
     <xsl:call-template name="printLabel"/>
   </th>
   <td align="left" valign="top">
    <xsl:call-template name="printErrors"/>
    <textarea>
      <xsl:attribute name="name"><xsl:value-of select="parameterName"/></xsl:attribute>
      <xsl:attribute name="rows"><xsl:value-of select="rows"/></xsl:attribute>
      <xsl:attribute name="cols"><xsl:value-of select="cols"/></xsl:attribute>
      <xsl:call-template name="printDefaultValue"/>
    </textarea>
   </td>
</xsl:template>

</xsl:stylesheet>