/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageFactory;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.page.BebopMapDispatcher;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ForumComponent;
import com.arsdigita.forum.ui.ThreadComponent;

import java.math.BigDecimal;

import org.apache.log4j.Logger;

/**
 * Maps the bboard user interface onto "index.jsp" and "thread.jsp".
 *
 * @author Kevin Scaldeferri
 * @author Vadim Nasardinov (vadimn@redhat.com)
 *
 * @version $Revision: #17 $ $Author: dan $ $DateTime: 2003/09/15 13:58:12 $
 */
public class BboardDispatcher extends BebopMapDispatcher
        implements Constants {
    public static final String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/BboardDispatcher.java#17 $" +
        "$Author: dan $" +
        "$DateTime: 2003/09/15 13:58:12 $";

    private static final String XSL_HOOK = "forum";

    private static final Logger s_log = Logger.getLogger
        (BboardDispatcher.class);

    /**
     * Constructor.  Instantiates the subsite url/page mapping.
     */
    public BboardDispatcher() {
        s_log.warn("BboardDispatcher created!");

        Page index = buildForumPage(new BigDecimalParameter(TOPIC_PARAM));
        addPage("", index);
        addPage("index.jsp", index);
        addPage("thread.jsp", buildThreadPage(
                    new BigDecimalParameter(THREAD_PARAM)));
    }

    static Page buildThreadPage(BigDecimalParameter stateParam) {
        Page threadPage = PageFactory.buildPage(XSL_HOOK, "Threads");
        threadPage.add(new ThreadComponent());
        // Register the thread id parameter as a global state parameter.
        threadPage.addGlobalStateParam(stateParam);
        threadPage.addRequestListener
            (new ThreadPageRequestListener(stateParam));
        threadPage.lock();
        return threadPage;
    }

    static Page buildForumPage(BigDecimalParameter stateParam) {
        Page page = PageFactory.buildPage(XSL_HOOK, "Forum");
        ForumComponent forumComp = new ForumComponent();
        page.add(forumComp);
        page.addGlobalStateParam(stateParam);
        page.addRequestListener(new ForumPageRequestListener(stateParam, forumComp));
        page.lock();
        return page;
    }

    private static class ThreadPageRequestListener implements RequestListener {
        private BigDecimalParameter m_threadID;

        public ThreadPageRequestListener(BigDecimalParameter threadID) {
            m_threadID = threadID;
        }


        public void pageRequested(RequestEvent event) {
            PageState state = event.getPageState();
            ForumContext context = ForumContext.getContext(state);
            context.setThreadID
                ((BigDecimal) event.getPageState().getValue(m_threadID));
        }
    }

    private static class ForumPageRequestListener implements RequestListener {
        private BigDecimalParameter m_categorySelection;
        private ForumComponent m_forumComp;

        public ForumPageRequestListener(BigDecimalParameter categorySelection,
                                        ForumComponent forumComp) {
            m_categorySelection = categorySelection;
            m_forumComp = forumComp;
        }

        public void pageRequested(RequestEvent event) {

            PageState state = event.getPageState();
            ForumContext context = ForumContext.getContext(state);

            context.setCategorySelection
                ((BigDecimal) event.getPageState().getValue(m_categorySelection));
        }
    }
}
