/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.runtime.AbstractConfig;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.URLParameter;
import com.arsdigita.util.parameter.StringParameter;
import com.arsdigita.util.UncheckedWrapperException;

import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.web.Web;

import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import org.apache.log4j.Logger;

/**
 * A set of configuration parameters for forums.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //apps/forum/dev/src/com/arsdigita/forum/ForumConfig.java#6 $
 */
public class ForumConfig extends AbstractConfig {
    public final static String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/ForumConfig.java#6 $" +
        "$Author: dan $" +
        "$DateTime: 2004/03/18 11:10:20 $";

    private static final Logger s_log = Logger.getLogger(ForumConfig.class);

    private Parameter m_adminEditPosts;
    private Parameter m_authorEditPosts;
    private Parameter m_digestUserEmail;
    private Parameter m_replyHostName;
    private final Parameter m_adapters;

    public ForumConfig() {
        m_adminEditPosts = new StringParameter(
            "com.arsdigita.forum.admin_can_edit_posts",
            Parameter.REQUIRED,
            Boolean.TRUE);
        m_authorEditPosts = new StringParameter(
            "com.arsdigita.forum.author_can_edit_posts",
            Parameter.REQUIRED,
            Boolean.TRUE);
        m_replyHostName = new StringParameter(
            "com.arsdigita.forum.reply_host_name",
            Parameter.OPTIONAL,
            null);
        m_digestUserEmail = new StringParameter(
            "com.arsdigita.forum.digest_user_email",
            Parameter.OPTIONAL,
            null);

        try {
            m_adapters = new URLParameter
                ("com.arsdigita.forum.traversal_adapters", 
                 Parameter.REQUIRED, 
                 new URL(null,
                         "resource:///WEB-INF/resources/forum-adapters.xml"));
        } catch (MalformedURLException ex) {
            throw new UncheckedWrapperException("Cannot parse URL", ex);
        }
        
        register(m_digestUserEmail);
        register(m_adminEditPosts);
        register(m_authorEditPosts);
        register(m_replyHostName);
        register(m_adapters);
        loadInfo();
    }

    InputStream getTraversalAdapters() {
        try {
            return ((URL)get(m_adapters)).openStream();
        } catch (IOException ex) {
            throw new UncheckedWrapperException("Cannot read stream", ex);
        }
    }

    public boolean canAdminEditPosts() {
        return ((Boolean)get(m_adminEditPosts)).booleanValue();
    }

    public boolean canAuthorEditPosts() {
        return ((Boolean)get(m_authorEditPosts)).booleanValue();
    }

    public String getDigestUserEmail() {
        String email = (String)get(m_digestUserEmail);
        if (email == null) {
            email = "forum-robot@" + Web.getConfig().getServer().getName();
        }
        return email;
    }

    public String getReplyHostName() {
        String hostName = (String)get(m_replyHostName);
        if (hostName == null) {
            hostName = Web.getConfig().getServer().getName();
        }
        return hostName;
    }
    
    public User getDigestUser() {
        String email = getDigestUserEmail();
        
        UserCollection users = User.retrieveAll();
        users.addEqualsFilter("primaryEmail", 
                              email);
        
        if (!users.next()) {
            throw new RuntimeException("cannot find user " + email);
        }
        
        User user = users.getUser();
        users.close();
        return user;
    }
}
