/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.db.DbHelper;
import com.arsdigita.bebop.RequestLocal;

import com.arsdigita.domain.xml.TraversalHandler;

import com.arsdigita.persistence.pdl.ManifestSource;
import com.arsdigita.persistence.pdl.NameFilter;

import com.arsdigita.runtime.CompoundInitializer;
import com.arsdigita.runtime.RuntimeConfig;
import com.arsdigita.runtime.PDLInitializer;
import com.arsdigita.runtime.DomainInitEvent;

import com.arsdigita.xml.XML;

import com.arsdigita.kernel.URLFinder;
import com.arsdigita.kernel.URLService;
import com.arsdigita.kernel.NoValidURLException;
import com.arsdigita.kernel.ACSObjectInstantiator;
import com.arsdigita.kernel.ResourceTypeConfig;
import com.arsdigita.kernel.ResourceType;
import com.arsdigita.kernel.ui.ResourceConfigComponent;
import com.arsdigita.kernel.ui.ResourceConfigFormSection;

import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DataObjectNotFoundException;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.web.Application;
import com.arsdigita.messaging.ThreadedMessage;

import com.arsdigita.forum.portlet.RecentPostingsPortlet;
import com.arsdigita.forum.ui.portlet.RecentPostingsPortletEditor;
import com.arsdigita.web.ui.ApplicationConfigFormSection;

import org.apache.log4j.Logger;

/**
 * The forum initializer.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //apps/forum/dev/src/com/arsdigita/forum/Initializer.java#28 $
 */
public class Initializer extends CompoundInitializer {
    public final static String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/Initializer.java#28 $" +
        "$Author: dan $" +
        "$DateTime: 2004/03/18 14:28:05 $";

    private static final Logger s_log = Logger.getLogger(Initializer.class);

    public Initializer() {
        final String url = RuntimeConfig.getConfig().getJDBCURL();
        final int database = DbHelper.getDatabaseFromURL(url);

        add(new PDLInitializer
            (new ManifestSource
             ("ccm-forum.pdl.mf",
              new NameFilter(DbHelper.getDatabaseSuffix(database), "pdl"))));
    }

    public void init(DomainInitEvent e) {
        super.init(e);
        
        e.getFactory().registerInstantiator(
            Forum.BASE_DATA_OBJECT_TYPE,
            new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new Forum(dataObject);
                }
            });
        e.getFactory().registerInstantiator(
            "com.arsdigita.forum.Inbox",
            new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new Forum(dataObject);
                }
            });

        e.getFactory().registerInstantiator(
            RecentPostingsPortlet.BASE_DATA_OBJECT_TYPE,
            new ACSObjectInstantiator() {
                protected DomainObject doNewInstance(DataObject dataObject) {
                    return new RecentPostingsPortlet(dataObject);
                }
            });

        e.getFactory().registerInstantiator(
            ForumSubscription.BASE_DATA_OBJECT_TYPE,
            new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    if (((Boolean)dataObject.get("isModerationAlert"))
                        .booleanValue()) {
                        s_log.debug("This is a mod alert");
                        return new ModerationAlert(dataObject);
                    } else {
                        s_log.debug("This is a subscription");
                        if (dataObject.get("digest") == null) {
                            return new ForumSubscription(dataObject);
                        } else {
                            return new DailySubscription(dataObject);
                        }
                    }
                }
            });
        
        XML.parse(Forum.getConfig().getTraversalAdapters(),
                  new TraversalHandler());
        
        URLFinder messageFinder = new URLFinder() {
                public String find(OID oid, String context) 
                    throws NoValidURLException {

                    return find(oid);
                }
                public String find(OID oid) throws NoValidURLException {
                    DataObject dobj = SessionManager.getSession().retrieve(oid);
                    
                    if (dobj == null) {
                        throw new NoValidURLException("No such data object " + oid);
                    }

                    Application app = Application.retrieveApplication(dobj);

                    if (app == null) {
                        throw new NoValidURLException
                            ("Could not find application instance for " + dobj);
                    }

                    try {
                        ThreadedMessage message = new ThreadedMessage(oid);
                        
                        String url = app.getPath() +
                            "/thread.jsp?threadID=" +
                            message.getThread().getID().toString();
                        
                        return url;
                    } catch(DataObjectNotFoundException e) {
                        throw new NoValidURLException
                            ("Could not find application instance for " + dobj);
                    }
                }
            };
        URLService.registerFinder(
            ThreadedMessage.BASE_DATA_OBJECT_TYPE, messageFinder);

        new ResourceTypeConfig(RecentPostingsPortlet.BASE_DATA_OBJECT_TYPE) {
            public ResourceConfigFormSection getCreateFormSection
                (final ResourceType resType, final RequestLocal parentAppRL) {
                final ResourceConfigFormSection config =
                    new RecentPostingsPortletEditor(resType, parentAppRL);
                
                return config;
            }
            
            public ResourceConfigFormSection getModifyFormSection
                (final RequestLocal application) {
                final RecentPostingsPortletEditor config =
                    new RecentPostingsPortletEditor(application);
                
                return config;
            }
        };

        new ResourceTypeConfig(Forum.BASE_DATA_OBJECT_TYPE) {
            public ResourceConfigFormSection getCreateFormSection
                (final ResourceType resType, final RequestLocal parentAppRL) {
                final ResourceConfigFormSection config =
                    new ApplicationConfigFormSection(resType, parentAppRL);
                
                return config;
            }
            
            public ResourceConfigFormSection getModifyFormSection
                (final RequestLocal application) {
                final ResourceConfigFormSection config =
                    new ApplicationConfigFormSection(application);
                
                return config;
            }
        };

    }
}
