/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.loader.PackageLoader;

import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelExcursion;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.EmailAddress;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;

import com.arsdigita.runtime.ScriptContext;

import com.arsdigita.web.ApplicationType;
import com.arsdigita.web.Application;

import com.arsdigita.portal.apportlet.AppPortletType;
import com.arsdigita.portal.PortletType;
import com.arsdigita.forum.portlet.RecentPostingsPortlet;

import org.apache.log4j.Logger;


/**
 * Loader.
 *
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //apps/forum/dev/src/com/arsdigita/forum/Loader.java#6 $
 */
public class Loader extends PackageLoader {
    public final static String versionId =
        "$Id: //apps/forum/dev/src/com/arsdigita/forum/Loader.java#6 $" +
        "$Author: dan $" +
        "$DateTime: 2004/03/18 14:20:38 $";

    private static final Logger s_log = Logger.getLogger(Loader.class);

    public void run(final ScriptContext ctx) {
        new KernelExcursion() {
            public void excurse() {
                setEffectiveParty(Kernel.getSystemParty());
                setupPrivileges();
                setupForumAppType();
                //setupInboxAppType();
                setupRecentPostingsPortletType();
                setupDigestUser();
            }
        }.run();
    }

    private static ApplicationType setupForumAppType() {
        ApplicationType type = ApplicationType
            .createApplicationType(Forum.PACKAGE_TYPE,
                                   "Discussion Forum Application",
                                   Forum.BASE_DATA_OBJECT_TYPE);
        type.setDescription("An electronic bulletin board system.");
        return type;
    }


    private static ApplicationType setupInboxAppType() {
        ApplicationType type = ApplicationType
            .createApplicationType(Forum.PACKAGE_TYPE,
                                   "Inbox",
                                   "com.arsdigita.forum.Inbox");
        type.setDescription("Inbox");
        return type;
    }

    public static AppPortletType setupRecentPostingsPortletType() {
        AppPortletType type = AppPortletType
            .createAppPortletType("Recent Forum Postings",
                                  PortletType.WIDE_PROFILE,
                                  RecentPostingsPortlet.BASE_DATA_OBJECT_TYPE);
        type.setProviderApplicationType(Forum.BASE_DATA_OBJECT_TYPE);
        type.setPortalApplication(true);
        type.setDescription("Displays the most recent postings " +
                            "to the bulletin board.");
        return type;
    }

    private static void setupDigestUser() {
        s_log.debug("Setting up the digest user");

        // Email address corresponding to the digest sender, as
        // specified in the configuration file.

        String email = Forum.getConfig().getDigestUserEmail();

        if (s_log.isDebugEnabled()) {
            s_log.debug("Creating a user with the email " + email);
        }

        User user = new User();
        user.setPrimaryEmail(new EmailAddress(email));
        user.getPersonName().setGivenName("Forum");
        user.getPersonName().setFamilyName("Digest Sender");
    }

    public static void setupPrivileges() {
        PrivilegeDescriptor.createPrivilege(
            Forum.FORUM_MODERATION_PRIVILEGE);
    }

}
