
/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum;

import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.messaging.ThreadedMessage;
import com.arsdigita.util.Assert;

import org.apache.log4j.Logger;


/**
 * Notifications for moderators are treated in a simlar manner to user
 * subscriptions to forums. This gives us additional possiblity to add
 * different notification options for moderators such as daily
 * digest. At the moment only immediate alerts are implmented.
 * Everyone that is subscribed has the forum_moderate privilege
 *
 *
 * @author Nobuko Asakai (nasakai@redhat.com)
 *
 * @version $Revision: #2 $ $Author: sskracic $ $DateTime: 2004/06/04 17:59:27 $
 */

public class ModerationAlert extends ForumSubscription {
    private static final Logger s_log
        = Logger.getLogger(ModerationAlert.class);

    public static final String MODERATION_ALERTS_QUERY
        = "com.arsdigita.forum.ModerationAlert";

    public static final String BASE_DATA_OBJECT_TYPE
           //= "com.arsdigita.forum.ModerationAlert";
           = "com.arsdigita.forum.ForumSubscription";

    protected void setupSubscriptionGroup() {}

    protected void setupSubscriptionGroup(Group moderationGroup) {

        setGroup(moderationGroup);

        PrivilegeDescriptor priv
            = PrivilegeDescriptor.get(Forum.FORUM_MODERATION_PRIVILEGE);
            PermissionDescriptor permission
                = new PermissionDescriptor(priv, this,
                                           moderationGroup);
    }

    /** All subscribed parties are granted the
     * Forum.FORUM_MODERATION_PRIVILEGE */

    protected ModerationAlert(DataObject data) {
        super(data);
    }

    public ModerationAlert(Forum forum, Group moderationGroup) {
        super(BASE_DATA_OBJECT_TYPE, forum);
        setIsModerationAlert(true);
        Assert.exists(moderationGroup, Group.class);
        setupSubscriptionGroup(moderationGroup);
    }

    /**
     * Returns a header for forum moderation alerts with the following standard
     * information:
     *
     * <pre>
     * Forum Moderation Alert
     * Forum    : Name
     * Subject  : Subject
     * com.arsdigita.messaging.ThreadedMessageed by: User
     * </pre>
     *
     * @return a header to insert at the top of the alert.
     */

    public String getHeader(ThreadedMessage msg) {
        StringBuffer sb = new StringBuffer();
        sb.append("Forum Moderation Alert\n");
        sb.append(super.getHeader(msg));
        return sb.toString();
    }

    public String getSignature(ThreadedMessage msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(SEPARATOR);
        sb.append(ALERT_BLURB);
        sb.append("You are receiving this email because you are a moderator ");
        sb.append("for this forum, please click on the url below to ");
        sb.append("reject/approve the message. ");
        sb.append(getReturnURLMessage((Post)msg));

        return sb.toString();
    }
}

