/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.portlet;

import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ThreadCollection;
import com.arsdigita.forum.ui.Constants;
import com.arsdigita.forum.ui.ThreadList;
import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.messaging.MessageThread;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.xml.Element;
import com.arsdigita.web.URL;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.Web;
import com.arsdigita.portal.apportlet.AppPortlet;


public class RecentPostingsPortlet extends AppPortlet {
    public static final String versionId = "$Id: //apps/forum/dev/src/com/arsdigita/forum/portlet/RecentPostingsPortlet.java#6 $ by $Author: dan $, $DateTime: 2003/09/15 13:58:12 $";

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.forum.RecentPostingsPortlet";

    private static final Integer DEFAULT_POSTS = new Integer(5);

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public RecentPostingsPortlet(DataObject dataObject) {
        super(dataObject);
    }

    public void initialize() {
        super.initialize();
        if (isNew()) {
            setNumPosts(DEFAULT_POSTS);
        }
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new RecentPostingsPortletRenderer(this);
    }

    public void setNumPosts(Integer iNumPosts) {
        set("numPosts", iNumPosts);
    }

    public Integer getNumPosts() {
        return (Integer) get("numPosts");
    }

}

class RecentPostingsPortletRenderer 
    extends AbstractPortletRenderer 
    implements Constants {

    private RecentPostingsPortlet m_portlet;

    public RecentPostingsPortletRenderer(RecentPostingsPortlet
                                         recentPostingsPortlet) {
        m_portlet = recentPostingsPortlet;
    }

    protected void generateBodyXML(PageState pageState,
                                   Element parent) {
        Element content = parent.newChildElement("forum:recentPostingsPortlet", 
                                                 FORUM_XML_NS);

        // XXX new post param

        Forum forum = (Forum)m_portlet.getParentApplication();
        Party party = Kernel.getContext().getParty();
        
        ThreadCollection threads = forum.getThreads(
            Kernel.getContext().getParty());

        threads.setRange(new Integer(1),
                         m_portlet.getNumPosts());

        while (threads.next()) {
            MessageThread thread = threads.getMessageThread();
            Element threadEl = content.newChildElement("forum:thread", FORUM_XML_NS);
            
            ParameterMap map = new ParameterMap();
            map.setParameter(THREAD_PARAM, thread.getID());
            URL url = URL.there(forum,
                                "/thread.jsp",
                                map);
            threadEl.addAttribute("url", url.toString());

            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(threadEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            
            xr.walk(thread, ThreadList.class.getName());
        }
    }

}
