/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;


import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;

import com.arsdigita.domain.DomainObjectXMLRenderer;
import com.arsdigita.domain.DomainCollection;

import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Kernel;

import com.arsdigita.messaging.MessageThread;

import com.arsdigita.web.Application;
import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.web.ParameterMap;

import com.arsdigita.xml.Element;

import com.arsdigita.forum.Forum;
import com.arsdigita.forum.Post;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.forum.ThreadSubscription;

import java.math.BigDecimal;


public class ThreadAlertsList extends SimpleComponent 
    implements Constants {

    private IntegerParameter m_pageNumber =
        new IntegerParameter(PAGINATOR_PARAM);
    
    private int m_pageSize = 5;

    public void register(Page p) {
        super.register(p);
        
        p.addGlobalStateParam(m_pageNumber);
    }

    public void generateXML(PageState state,
                            Element parent) {
        Element content = parent.newChildElement(
            "forum:threadAlertList", FORUM_XML_NS);
        exportAttributes(content);

        DomainCollection subs = ThreadSubscription.
            getSubsForUser(Kernel.getContext().getParty());

        while (subs.next()) {
            ThreadSubscription sub = (ThreadSubscription)subs.getDomainObject();
            content.addContent(generateAlertXML(sub));
        }
        
    }
    
    
    public Element generateAlertXML(ThreadSubscription sub) {
        Element subEl = new Element(
            "forum:threadAlert", FORUM_XML_NS);

        ParameterMap map = new ParameterMap();
        map.setParameter(THREAD_PARAM, sub.getThreadReal().getID());
        URL url = URL.there((Application)Kernel.getContext().getResource(),
                            "/thread.jsp",
                            map);
        subEl.addAttribute("url", url.toString());

        
        DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(subEl);
        xr.setWrapRoot(false);
        xr.setWrapAttributes(true);
        xr.setWrapObjects(false);
        
        xr.walk(sub, ThreadAlertsList.class.getName());
        return subEl;
    }
}
