/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;

import com.arsdigita.domain.DomainObjectXMLRenderer;

import com.arsdigita.persistence.DataAssociationCursor;

import com.arsdigita.web.URL;
import com.arsdigita.web.Web;
import com.arsdigita.web.ParameterMap;

import com.arsdigita.xml.Element;

import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.categorization.Category;

import java.math.BigDecimal;


public class TopicSelector extends SimpleComponent implements Constants {
    
    public void generateXML(PageState state,
                            Element parent) {
        Element content = parent.newChildElement("forum:topicSelector", 
                                                 FORUM_XML_NS);

        URL url = URL.request(state.getRequest(), null);
        
        BigDecimal id = ForumContext.getContext(state).getCategorySelection();
        if (id != null) {
            content.addAttribute("currentTopicID", id.toString());
        }
        content.addAttribute("baseURL", url.toString());
        content.addAttribute("param", TOPIC_PARAM);
        content.addAttribute("anyTopicID", TOPIC_ANY.toString());
        content.addAttribute("noTopicID", TOPIC_NONE.toString());

        Forum forum = ForumContext.getContext(state).getForum();
        DataAssociationCursor cursor =
            forum.getFilledCategories();
        
        while (cursor.next()) {
            Category c = new Category(cursor.getDataObject());
            Element topicEl = content.newChildElement("forum:topic", FORUM_XML_NS);
            DomainObjectXMLRenderer xr = new DomainObjectXMLRenderer(topicEl);
            xr.setWrapRoot(false);
            xr.setWrapAttributes(true);
            xr.setWrapObjects(false);
            
            xr.walk(c, TopicSelector.class.getName());
        }
    }    
}

