/*
 * Copyright (C) 2001 ArsDigita Corporation. All Rights Reserved.
 *
 * The contents of this file are subject to the ArsDigita Public 
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.arsdigita.com/ADPL.txt
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.forum.ui.admin;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.forum.Forum;
import com.arsdigita.forum.ForumContext;
import com.arsdigita.kernel.Group;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;



/** 
 * Wrapper class to have com.arsdigita.ui.permissions.PermissionsPane
 * play nice with Workspaces.
 */


public class ModeratorEditPane extends SimpleContainer {
    private Forum m_forum;
    
    private static final Logger s_log = Logger.getLogger(ModeratorEditPane.class);

    public ModeratorEditPane() {

        GroupMemberDisplay members = new GroupMemberDisplay() {
                public Group getGroup(PageState state) {
                    Forum forum = ForumContext.getContext(state).getForum();
                    Group g = forum.getModerationGroup();
                    Assert.exists(g, Group.class);
                    if (s_log.isDebugEnabled()) {
                        // check that moderator group has the right permissions
                        if (forum.canModerate(g)) {
                            s_log.debug(g.getName() + "has the moderation permission");
                        } else {
                            s_log.debug(g.getName() 
                                        + "Insufficient permissions for group");
                        }

                    }
                    return g;
                }
            };
        add(members);

        Form form = new Form("userPicker", 
                             new BoxPanel(BoxPanel.VERTICAL));
        form.add(new GroupMemberPicker() {
                public Group getGroup(PageState state) {
                    Forum forum = ForumContext.getContext(state).getForum();
                    return forum.getModerationGroup();
                }
            });
        form.setIdAttr("memberUserPicker");
        add(form);
        
    }
}
