/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;

public class RC5ParameterSpec
implements AlgorithmParameterSpec {
    private byte[] a;
    private int b;
    private int c;
    private int d;

    public RC5ParameterSpec(int n2, int n3, int n4) {
        this.b = n2;
        this.c = n3;
        this.d = n4;
    }

    public RC5ParameterSpec(int n2, int n3, int n4, byte[] byArray) {
        this(n2, n3, n4, byArray, 0);
    }

    public RC5ParameterSpec(int n2, int n3, int n4, byte[] byArray, int n5) {
        this.b = n2;
        this.c = n3;
        this.d = n4;
        if (byArray == null) {
            throw new IllegalArgumentException("IV missing");
        }
        int n6 = n4 / 8 * 2;
        if (byArray.length - n5 < n6) {
            throw new IllegalArgumentException("IV too short");
        }
        this.a = new byte[n6];
        System.arraycopy(byArray, n5, this.a, 0, n6);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RC5ParameterSpec)) {
            return false;
        }
        RC5ParameterSpec rC5ParameterSpec = (RC5ParameterSpec)object;
        return this.b == rC5ParameterSpec.b && this.c == rC5ParameterSpec.c && this.d == rC5ParameterSpec.d && Arrays.equals(this.a, rC5ParameterSpec.a);
    }

    public byte[] getIV() {
        if (this.a != null) {
            return (byte[])this.a.clone();
        }
        return null;
    }

    public int getRounds() {
        return this.c;
    }

    public int getVersion() {
        return this.b;
    }

    public int getWordSize() {
        return this.d;
    }

    public int hashCode() {
        int n2 = 0;
        if (this.a != null) {
            int n3 = 1;
            while (n3 < this.a.length) {
                n2 += this.a[n3] * n3;
                ++n3;
            }
        }
        return n2 += this.b + this.c + this.d;
    }
}

