/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto.spec;

import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class SecretKeySpec
implements KeySpec,
SecretKey {
    private byte[] key;
    private String algorithm;

    public SecretKeySpec(byte[] byArray, int n2, int n3, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        if (byArray.length - n2 < n3) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        this.key = new byte[n3];
        System.arraycopy(byArray, n2, this.key, 0, n3);
        this.algorithm = string;
    }

    public SecretKeySpec(byte[] byArray, String string) {
        if (byArray == null || string == null) {
            throw new IllegalArgumentException("Missing argument");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty key");
        }
        this.key = (byte[])byArray.clone();
        this.algorithm = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        String string = ((SecretKey)object).getAlgorithm();
        if (!(string.equalsIgnoreCase(this.algorithm) || string.equalsIgnoreCase("DESede") && this.algorithm.equalsIgnoreCase("TripleDES") || string.equalsIgnoreCase("TripleDES") && this.algorithm.equalsIgnoreCase("DESede"))) {
            return false;
        }
        byte[] byArray = ((SecretKey)object).getEncoded();
        return Arrays.equals(this.key, byArray);
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        return (byte[])this.key.clone();
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n2 = 0;
        int n3 = 1;
        while (n3 < this.key.length) {
            n2 += this.key[n3] * n3;
            ++n3;
        }
        if (this.algorithm.equalsIgnoreCase("TripleDES")) {
            return n2 ^= "desede".hashCode();
        }
        return n2 ^= this.algorithm.toLowerCase().hashCode();
    }
}

