#
# CCM::Interpolate
#
# Copyright (C) 2003 Red Hat, Inc.
#
# $Id: //tools/ccmbuild/tools/dev/lib/CCM/Interpolate.pm#7 $

=pod

=head1 NAME

CCM:Interpolate

=head1 SYNOPSIS

=head1 DESCRIPTION

=head1 METHODS

=over 4

=cut

package CCM::Interpolate;

use vars qw(@ISA @EXPORT_OK);
require Exporter;

@ISA = qw(Exporter);
@EXPORT_OK = qw(interpolate_string interpolate_file);  # symbols to export on request

my $regexp = '[-\.\w\d]+';

sub interpolate_string {
    my $text = shift;
    my $vars = shift;
    my $extravars = shift;

    $text =~ s/::($regexp)::/&lookup($1, $vars, $extravars)/gex;

    return $text;
}

sub interpolate_file {
    my $src = shift;
    my $dst = shift;
    my $vars = shift;
    my $extravars = shift;

    open SRC, "<$src"
        or die "cannot read $src: $!";
    open DST, ">$dst"
        or die "cannot write $dst: $!";

    while (<SRC>) {
        s/::($regexp)::/&lookup($1, $vars, $extravars)/gex;
        print DST;
    }

    close SRC;
    close DST;
}

sub lookup {
    my $key = shift or die "no key supplied";
    my $vars = shift or die "no vars supplied";
    my $extravars = shift;

    if (defined $extravars && exists $extravars->{$key}) {
        return $extravars->{$key};
    }

    if (defined $vars && exists $vars->{$key}) {
        return $vars->{$key};
    }

    if ($key =~ /^($regexp)$/) {
        $key = $1;
    } else {
        die "key '$key' must only contain alphanumerics plus '.','_','-'";
    }

    $ENV{'PATH'} =~ /^(.*)$/;
    $ENV{'PATH'} = $1;

    my $command = "ccm get --value $key";
    my $output = `$command`;

    if (! defined ($output)) {
        die "error running '$command': $!\n";
    }

    chomp($output);

    $extravars->{$key} = $output;

    return $output;
}

sub appendVars {
    my $file = shift;
    my $vars = shift;

    if ( open (IN, "< $file") ) {
        local $/;
        $/ = undef;

        my $file = <IN>;

        while ( $file =~ /([-\w]+)[\s]*=>[\s]*(.+?)[\s]*$/gm ) {
            $vars->{$1} = $2 unless exists $vars->{$1};
        }
        close IN;
    }
}

1 # So that the require or use succeeds.

__END__

=back 4

=head1 AUTHORS

=head1 COPYRIGHT

=head1 SEE ALSO

L<perl(1)>

=cut
