Summary: A public domain clone of the Korn shell (ksh).
Name: pdksh
Version: 5.2.14
Release: 12a
License: Public Domain
Group: System Environment/Shells
Patch0: pdksh-5.2.14-manloc.patch
Patch1: pdksh-5.2.14-patches1.patch
Patch2: pdksh-5.2.14-alignia64.patch
Patch3: pdksh-5.2.14-patches2.patch
Patch4: pdksh-5.2.14-noctty.patch
Source: ftp://ftp.cs.mun.ca/pub/pdksh/pdksh-%{version}.tar.gz
URL: http://www.cs.mun.ca/~michael/pdksh/
BuildRoot: %{_tmppath}/%{name}-%{version}-root
PreReq: grep , fileutils

%description
The pdksh package contains PD-ksh, a clone of the Korn shell (ksh).
The ksh shell is a command interpreter intended for both interactive
and shell script use.  Ksh's command language is a superset of the sh
shell language.

Install the pdksh package if you want to use a version of the ksh
shell.

%prep
%setup -q
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p1
%patch4 -p1

%build

%configure --bindir=/bin --enable-shell=sh
make

%install
rm -rf $RPM_BUILD_ROOT

%makeinstall bindir=$RPM_BUILD_ROOT/bin
mv $RPM_BUILD_ROOT/bin/sh $RPM_BUILD_ROOT/bin/ksh
mv $RPM_BUILD_ROOT/%{_mandir}/man1/sh.1 $RPM_BUILD_ROOT/%{_mandir}/man1/ksh.1

mkdir -p $RPM_BUILD_ROOT/usr/bin
ln -sf ../../bin/ksh $RPM_BUILD_ROOT/usr/bin/ksh
ln -sf ../../bin/ksh $RPM_BUILD_ROOT/usr/bin/pdksh
ln -sf ksh.1 $RPM_BUILD_ROOT/%{_mandir}/man1/pdksh.1

%clean
rm -rf $RPM_BUILD_ROOT

%post
if [ ! -f /etc/shells ]; then
	echo "/bin/ksh" > /etc/shells
else
	if ! grep -q '^/bin/ksh$' /etc/shells ; then
		echo "/bin/ksh" >> /etc/shells
	fi
fi

%postun
if [ ! -f /bin/ksh ]; then
	grep -v /bin/ksh /etc/shells > /etc/shells.new
	mv /etc/shells.new /etc/shells
fi

%verifyscript

echo -n "Looking for ksh in /etc/shells... "
if ! grep '^/bin/ksh$' /etc/shells > /dev/null; then
    echo "missing"
    echo "ksh missing from /etc/shells" >&2
else
    echo "found"
fi

%files
%defattr(-,root,root)
%doc README NOTES PROJECTS NEWS BUG-REPORTS
/bin/ksh
/usr/bin/ksh
/usr/bin/pdksh
%{_mandir}/*/*

%changelog
* Sun Feb 25 2001 Trond Eivind Glomsrd <teg@redhat.com>
- Add patch from author to fix some init problems

* Tue Jan 23 2001 Trond Eivind Glomsrd <teg@redhat.com>
- add fileutils and grep to PreReq: (#24720)

* Mon Jan 08 2001 Trond Eivind Glomsrd <teg@redhat.com>
- add patch to fix alignment problems on IA64 (#23351)

* Tue Nov 28 2000 Trond Eivind Glomsrd <teg@redhat.com>
- redid some patches, which should fix #19517

* Mon Aug 14 2000 Trond Eivind Glomsrd <teg@redhat.com>
- use relative symlinks (#16127)

* Sat Jul 29 2000 Trond Eivind Glomsrd <teg@redhat.com>
- added patch to handle readonly variables correctly

* Mon Jul 24 2000 Trond Eivind Glomsrd <teg@redhat.com>
- add patch from author to fix "-x" problem (#10758)
- add another author patch (some fixes wrt. job handling)

* Fri Jul 21 2000 Trond Eivind Glomsrd <teg@redhat.com>
- add URL
- use %%makeinstall and add a patch to make it work

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Tue Jun 13 2000 Trond Eivind Glomsrd <teg@redhat.com>
- use %%{_mandir}, %%configure and %{_tmpdir}

* Mon Feb  7 2000 Jeff Johnson <jbj@redhat.com>
- compress man pages.

* Tue Jul 20 1999 Jeff Johnson <jbj@redhat.com>
- update to 5.2.14.

* Sun Mar 21 1999 Cristian Gafton <gafton@redhat.com> 
- auto rebuild in the new build environment (release 3)

* Wed Mar 17 1999 Jeff Johnson <jbj@redhat.com>
- glibc 2.1 doesn't init sys_siglist for 32 <= i < NSIG (#1473)

* Fri Mar 12 1999 Jeff Johnson <jbj@redhat.com>
- upgrade to 5.2.13.

* Sun Aug 16 1998 Jeff Johnson <jbj@redhat.com>
- build root

* Mon Apr 27 1998 Prospector System <bugs@redhat.com>
- translations modified for de, fr, tr

* Wed Oct 21 1997 Cristian Gafton <gafton@redhat.com>
- fixed the spec file

* Fri Jul 18 1997 Erik Troan <ewt@redhat.com>
- built against glibc
