# Maintainer util-linux@math.uio.no

Summary: The login command for the S/390 installer
Name: login
Version: 2.11f
Release: 9
Copyright: distributable
Group: System Environment/Base
Source0: ftp://ftp.kernel.org/pub/linux/utils/util-linux/util-linux-%{version}.tar.bz2
Source1: util-linux-2.7-login.pamd
Source2: util-linux-2.7-chfn.pamd
Source3: util-linux-2.7-chsh.pamd
Source6: mkcramfs.c
Source7: cramfs.h
Source8: nologin.c
Source9: nologin.8
Source10: kbdrate.tar.gz

BuildRequires: pam-devel
BuildRequires: ncurses-devel
BuildRequires: libtermcap-devel
BuildRequires: slang-devel
BuildRequires: zlib-devel

Patch0: util-linux-2.11a-rhconfig.patch
Patch1: util-linux-2.10e-nochkdupexe.patch
Patch2: util-linux-2.11a-gecossize.patch

# XXX apply next patch to enable mount-2.8 from util-linux (not applied)
Patch4: util-linux-2.9i-mount.patch

Patch8: util-linux-2.9i-nomount.patch
Patch9: util-linux-2.11f-vipw.patch
Patch21: util-linux-2.9v-nonroot.patch
Patch27: util-linux-2.11a-moretc.patch
Patch35: util-linux-2.10m-loginpath.patch
Patch60: util-linux-2.10s-s390x.patch
Patch61: util-linux-2.11b-s390x.patch

Patch70: util-linux-2.11f-miscfixes.patch

# This patch got added upstream in 2.11. Then we reverted it from our
# local 2.10s copy. Oops.
Patch75: util-linux-2.11f-logingrp-revert.patch

Patch100: mkcramfs.patch
Patch101: mkcramfs-quiet.patch

Obsoletes: fdisk tunelp
%ifarch alpha sparc sparc64 sparcv9 s390
Obsoletes: clock
%endif
%ifarch alpha
Conflicts: initscripts <= 4.58, timeconfig <= 3.0.1
%endif
BuildRoot: %{_tmppath}/%{name}-root
Requires: pam >= 0.66-4, /etc/pam.d/system-auth
Conflicts: kernel < 2.2.12-7, 
Prereq: /sbin/install-info

%description
This package contains only one file: /bin/login and it intended only
for the S/390 installer.

%prep

%setup -q -a 10 -n util-linux-%{version}

%patch0 -p1 -b .rhconfig
%patch1 -p1 -b .nochkdupexe
%patch2 -p1 -b .gecos

# mount comes from its own rpm (again)
#%patch4 -p1 -b .mount

%patch8 -p1 -b .nomount
%patch21 -p1 -b .nonroot

%patch27 -p1 -b .moretc
%patch35 -p1 -b .loginpath

%ifarch s390 s390x
%patch60 -p1 -b .s390x2
%patch61 -p1 -b .s390x
%endif

%patch70 -p1

%patch75 -p1

# mkcramfs
cp %{SOURCE7} %{SOURCE6} .
%patch100 -p1 -b .mkcramfs
%patch101 -p1 -b .quiet

# nologin
cp %{SOURCE8} %{SOURCE9} .

%build
unset LINGUAS || :

%configure

cd login-utils

make HAVE_PAM=no login

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/bin

install -s -m 755 login-utils/login ${RPM_BUILD_ROOT}/bin

%files 
%defattr(-,root,root)
/bin/login

%changelog
* Wed Aug 29 2001 Karsten Hopp <karsten@redhat.de>
- util-linux version which builds only /bin/login
