#!/usr/bin/env python

import sys, os

def getKDEDocDir():
    prefix = os.popen("kde-config --prefix", "r").read().strip()
    if not prefix:
        prefix = "/opt/kde3"
    return prefix + "/share/doc"

def addRoot():
    output = os.popen("beagle-config indexing ListRoots", "r").readlines()
    if not output:
        return False

    kdedocdir = getKDEDocDir()
    for line in output:
        if line.find(kdedocdir) != -1:
            break
    else:
        os.system("beagle-config indexing AddRoot %s" % kdedocdir)

    return True

def createExistsFile(idir, ident):
    import os.path
    filename = os.path.join(idir, ident + ".exists")
    print filename
    f = open(filename, "w")
    f.close()

if __name__ == '__main__':
    idir = sys.argv[1]
    ident = sys.argv[2]
    if addRoot():
        createExistsFile(idir, ident)
