/*****************************************************************

Copyright (c) 2006 Stephan Binner <binner@kde.org>
                   Stephan Kulow <coolo@kde.org>
                   Dirk Mueller <mueller@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __knewbutton_h__
#define __knewbutton_h__

#include "kbutton.h"

#include <qmovie.h>
#include <qpoint.h>

/**
 * Button that contains the PanelKMenu and client menu manager.
 */
class KNewButton : public KButton
{
    Q_OBJECT

public:
    KNewButton( QWidget *parent );
    ~KNewButton();

    static KNewButton *self() { return m_self; }

    void loadConfig( const KConfigGroup& config );

    virtual const QPixmap& labelIcon() const;

    bool active() const { return m_active; }
    void setActive(bool a) { m_active = a; updateMovie(); }
    QColor borderColor() const;

private slots:
    void slotStatus(int);
    void slotStopAnimation();
    void updateMovie();

protected:
    virtual void show();
    virtual void slotExecMenu();
    virtual QString tileName() { return "KMenu"; }
    virtual QString defaultIcon() const { return "go"; }

    virtual void enterEvent(QEvent* e);
    virtual void leaveEvent(QEvent* e);
    virtual void dragEnterEvent(QDragEnterEvent*);
    virtual void dragLeaveEvent(QDragLeaveEvent*);
    virtual bool eventFilter(QObject *, QEvent *);
    void timerEvent(QTimerEvent*);

private:
    void drawEye();

    QMovie m_movie;
    QPixmap m_pixmap, m_orig_pixmap, m_active_pixmap;
    QPoint m_oldPos;
    int m_hoverTimer;
    int m_openTimer;
    bool m_active;
    bool m_mouseInside;
    bool m_drag;

    static KNewButton *m_self;
};

#endif
