/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __itemview_h__
#define __itemview_h__

#include <dcopobject.h>
#include <qintdict.h>
#include <qpixmap.h>
#include <qframe.h>
#include <qtoolbutton.h>
#include <klistview.h>
#include <qdragobject.h>

#include "kmenubase.h"
#include "kmenuitembase.h"
#include "service_mnu.h"

class KickerClientMenu;
class KBookmarkMenu;
class KActionCollection;
class KBookmarkOwner;
class Panel;
class QWidgetStack;
class KHistoryCombo;
class QScrollView;
class PopupMenuTitle;
class QWidget;
class QVBoxLayout;
class QTimer;
class KPixmap;

class KMenuItem : public QListViewItem
{
public:
    KMenuItem(int nId, QListView* parent) : QListViewItem(parent), m_id(nId) { init(); }
    KMenuItem(int nId, QListViewItem* parent) : QListViewItem(parent), m_id(nId) { init(); }
    ~KMenuItem();

    void setIcon(const QString& icon, int size);
    QString icon() const { return m_icon; }
    void setTitle( const QString& text );
    QString title() const { return m_title; }
    void setToolTip( const QString& text );
    QString toolTip() const { return m_tooltip; }
    void setDescription(const QString& text);
    QString description() const { return m_description; }
    void setService(KService::Ptr& s) { m_s = s; }
    KService::Ptr service() { return m_s; }
    void setPath(const QString& u) { m_path = u; }
    QString path() const { return m_path; }
    void setMenuPath(const QString& u) { m_menuPath = u; }
    QString menuPath() const { return m_menuPath; }
    int id() const { return m_id; }
    void setHasChildren(bool flag);
    bool hasChildren() const { return m_has_children; }
    void makeGradient(KPixmap &off, const QColor& c);

protected:
    virtual void paintCell(QPainter* p, const QColorGroup & cg, int column, int width, int align);
    int width ( const QFontMetrics & fm, const QListView * lv, int c );
    virtual void paintCellInter(QPainter* p, const QColorGroup & cg, int column, int width, int align);
    virtual void setup();

private:
    void init();

    int m_id;
    KService::Ptr m_s;
    QString m_title;
    QString m_description;
    QString m_path;
    QString m_icon;
    QString m_tooltip;
    QString m_menuPath;
    float title_font_size;
    float description_font_size;
    bool m_has_children;
    int m_old_width;
    QPixmap right_triangle;
};

class KMenuItemSeparator : public KMenuItem
{
public:
    KMenuItemSeparator(int nId, QListView* parent);
    virtual void setup();

    virtual void paintCell(QPainter* p, const QColorGroup & cg, int column, int width, int align);
    void setLink(const QString &text, const QString &link = QString::null );

    QString linkUrl() const { return m_link_url; }

    /// returns true if the cursor has to change
    bool hitsLink(const QPoint &pos);

protected:
    void preparePixmap(int width);
    QPixmap pixmap;
    int left_margin;

private:
    QListView* lv;
    int cached_width;
    QString m_link_text, m_link_url;
    QRect m_link_rect;

};

class KMenuItemHeader : public KMenuItemSeparator
{
public:
    KMenuItemHeader( int nId, const QString &relpath, QListView* parent);
    virtual void setup();

    virtual void paintCell(QPainter* p, const QColorGroup & cg, int column, int width, int align);

private:
    QListView* lv;
    QStringList paths;
    QStringList texts;
    QStringList icons;
    QPixmap left_triangle;
};

class KMenuSpacer : public KMenuItem
{
public:
    KMenuSpacer(int nId, QListView* parent);
    virtual void paintCell(QPainter* p, const QColorGroup & cg, int column, int width, int align);
    virtual void setup();

    void setHeight(int);
};

class ItemView : public KListView
{
    friend class KMenuItem;

    Q_OBJECT
public:
    ItemView(QWidget* parent, const char* name = 0);

    KMenuItem* insertItem( const QString& icon, const QString& text, const QString& description, int nId, int nIndex, KMenuItem* parentItem = 0 );
    KMenuItem* insertItem( const QString& icon, const QString& text, const QString& description, const QString& path, int nId, int nIndex, KMenuItem* parentItem = 0 );
    int insertItem( PopupMenuTitle*, int, int);
    int setItemEnabled(int id, bool enabled);
    KMenuItemSeparator *insertSeparator(int id, const QString& text, int nIndex);
    KMenuItemHeader *insertHeader(int id, const QString &relpath);
    KMenuItem* insertMenuItem(KService::Ptr & s, int nId, int nIndex = -1, KMenuItem* parentItem = 0,
                        const QString &aliasname = QString::null, const QString &label = QString::null,
                        const QString &categoryIcon = QString::null);
    KMenuItem* insertRecentlyItem(const QString& s, int nId, int nIndex = -1);
    KMenuItem* insertDocumentItem(const QString& s, int nId, int nIndex = -1 , const QStringList* suppressGenericNames = 0,
                        const QString& aliasname = QString::null);
    KMenuItem* insertSubItem(const QString& icon, const QString& caption, const QString& description, const QString& path, KMenuItem* parentItem);
    KMenuItem* findItem(int nId);

    void setIconSize(int size) { m_iconSize = size; }
    void setMouseMoveSelects(bool select) { m_mouseMoveSelects = select; }
    void clear();
    int goodHeight();
    QString path;
    void setBackPath( const QString &str ) { m_back_url = str; }
    QString backPath() const { return m_back_url; }

public slots:
    void slotItemClicked(QListViewItem*);
    void slotMoveContent();

signals:
    void startService(KService::Ptr kservice);
    void startURL(const QString& u);

protected:
    void contentsMouseMoveEvent(QMouseEvent *e);
    void contentsMousePressEvent ( QMouseEvent * e );
    void contentsWheelEvent(QWheelEvent *e);
    void leaveEvent(QEvent *e);
    virtual void resizeEvent ( QResizeEvent * e );
    virtual void viewportPaintEvent ( QPaintEvent * pe );
    virtual QDragObject* dragObject ();
    virtual bool acceptDrag (QDropEvent* event) const;
    virtual bool focusNextPrevChild(bool next);

private slots:
    void slotItemClicked(int button, QListViewItem * item, const QPoint & pos, int c );

private:
    KMenuItem* itemAtIndex(int nIndex);
    void moveItemToIndex(KMenuItem*, int);

    QWidget* m_itemBox;
    QVBoxLayout* m_itemLayout;
    KMenuItem *m_lastOne;
    KMenuSpacer *m_spacer;

    QString m_back_url;

    bool m_mouseMoveSelects;
    int m_iconSize;
    int m_old_contentY;
};

class FavoritesItemView : public ItemView
{
public:
    FavoritesItemView(QWidget* parent, const char* name = 0);

protected:
    virtual bool acceptDrag (QDropEvent* event) const;
};

class KMenuItemInfo
{
public:
    int m_id;
    KService::Ptr m_s;
    QString m_title;
    QString m_description;
    QString m_path;
    QString m_icon;
};

class KMenuItemDrag : public QDragObject
{
    public:
        KMenuItemDrag(KMenuItem& item, QWidget *dragSource);
        ~KMenuItemDrag();

        virtual const char * format(int i = 0) const;
        virtual QByteArray encodedData(const char *) const;

        static bool canDecode(const QMimeSource * e);
        static bool decode(const QMimeSource* e, KMenuItemInfo& item);

    private:
        QByteArray a;
};

#endif
