/*****************************************************************

Copyright (c) 2006 Stephan Kulow <coolo@novell.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef _media_watcher_
#define _media_watcher_

#include <dcopobject.h>
#include <qobject.h>
#include <qstringlist.h>

class MediaWatcher : public QObject, public DCOPObject
{
    Q_OBJECT
    K_DCOP

    QStringList m_devices;
    void updateDevices();

k_dcop:
    void slotMediumAdded(QString medium, bool a);

signals:
    void mediumChanged();

public:
    MediaWatcher(QObject *parent);

    QStringList devices() const { return m_devices; }
};

#endif
