#include <cstdlib>
using namespace std;
#include "GlStatus.h"


GlStatus::GlStatus() {
	currentAccel = 0;
	// until I rewrite the test in C++
	int GlTestReturn = system("./gltest.py");
	// the return status is what we want; system() collects it bitshifted left one byte
	int GlStatus = GlTestReturn >> 8;
	// the following test the four interesting bits returned by gltest
	if (GlStatus % 2) {XGLPresent = true;}
	if ((GlStatus >> 1) % 2) {XGLEnabled = true; currentAccel = 1;}
	if ((GlStatus >> 2) % 2) {AIGLXPresent = true;}
	if ((GlStatus >> 3) % 2) {AIGLXEnabled = true; currentAccel = 2;}
	if ((GlStatus >> 4) % 2) {currentAccel = 0; glState = 0;}
}

int GlStatus::getCurrentAccel() {
	return currentAccel;
}

bool GlStatus::setCurrentAccel(int T_accel) {
	currentAccel = T_accel;
	return true;
}

bool GlStatus::getXGLPresent() {
	return XGLPresent;
}

bool GlStatus::getXGLEnabled() {
	return XGLEnabled;
}

bool GlStatus::getAIGLXPresent() {
	return AIGLXPresent;
}

bool GlStatus::getAIGLXEnabled() {
	return AIGLXEnabled;
}

bool GlStatus::getNVidiaPresent() {
	return NVidiaPresent;
}

bool GlStatus::getNVidiaEnabled() {
	return NVidiaEnabled;
}

bool GlStatus::setXGLEnabled(bool state) {
	// the path could change at somepoint
	if (state) {
		int returnValue = system("/sbin/xgl-setup enable");
		returnValue = returnValue >> 8;
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	} else {
		int returnValue = system("/sbin/xgl-setup disable");
		returnValue = returnValue >> 8;
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	}
}

bool GlStatus::setAIGLXEnabled(bool state) {
	// the path could change at somepoint
	if (state) {
		int returnValue = system("/sbin/aiglx-setup enable");
		returnValue = returnValue >> 8;
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	} else {
		int returnValue = system("/sbin/aiglx-setup disable");
		returnValue = returnValue >> 8;
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	}
}

bool GlStatus::setNVidiaEnabled(bool state) {
	// the path could change at somepoint
	if (state) {
		int returnValue = system("./desktop-acceleration-setup nvidia enable");
		returnValue = returnValue >> 8;
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	} else {
		int returnValue = system("./desktop-acceleration-setup nvidia disable");
		returnValue = returnValue >> 8;
		if (returnValue == 0) {
			return true;
		} else {
			return false;
		}
	}
}

void GlStatus::disableAcceleration() {
	switch(currentAccel) {
		case 0: break;
		case 1: setXGLEnabled(false); break;
		case 2: setAIGLXEnabled(false); break;
		case 3: setNVidiaEnabled(false); break;
	}
}