#ifndef GL_STATUS_H
#define GL_STATUS_H

class GlStatus {
	private:
		// the below indicates the OpenGL status: NULL for unknown, 0 for off, 1 for on.
		bool glState;
		// this indicates the possibility of XGL acceleration; NULL for unknown, 0 for no, 1 for yes.
		bool XGLPresent;
		// this indicates the possibility of AIGLX acceleration; NULL for unknown, 0 for no, 1 for yes.
		bool AIGLXPresent;
		// this indicates the possibility of NVidia acceleration; NULL for unknown, 0 for no, 1 for yes.
		bool NVidiaPresent;
		// if present, this indicates the current state of XGL
		bool XGLEnabled;
		// if present, this indicates the current state of AIGLX
		bool AIGLXEnabled;
		// if present, this indicates the current state of NVidia acceleration
		bool NVidiaEnabled;
		// the following represents the acceleration status, 0 for none, 1 for xgl, 2 for aiglx, 3 for nvidia
		int currentAccel;
	public:
		// unsurprisingly, this simply runs a series of checks to find the system's status, then stores that data
		GlStatus();
		// standard accessor/mutator functions. The mutators return boolean values indicating success.
		int getCurrentAccel();
		bool setCurrentAccel(int);
		bool getXGLPresent();
		bool getAIGLXPresent();
		bool getNVidiaPresent();
		bool getXGLEnabled();
		bool getAIGLXEnabled();
		bool getNVidiaEnabled();
		bool setXGLEnabled(bool);
		bool setAIGLXEnabled(bool);
		bool setNVidiaEnabled(bool);
		void disableAcceleration();
};

#endif

