#include <iostream>
using namespace std;
#include <QtGui>
#include <QButtonGroup>
#include <QMessageBox>
#include "accelManagerGUI.h"

AccelManagerGUI::AccelManagerGUI(QWidget *parent) : QMainWindow(parent) {
	
	// this simply creates a new data storage class
	gl = new GlStatus;

	// creates a QWidget to act as a parent to groupie and a central widget to main
	widget = new QWidget;
		setCentralWidget(widget);

	// creates a new group for the radio buttons
	groupie = new QButtonGroup(widget);
		groupie->setExclusive(true);

	//sets and initializes the status of the None radio button
	none = new QRadioButton(tr("&None:"));
		groupie->addButton(none);
		groupie->setId(none, 0);
		if (gl->getCurrentAccel() == 0) {
			none->setEnabled(true);
		} else {
			none->setEnabled(false);
		}

	// the following simply initializes and sets the status of the XGL radio button.
	// Tabbed for easy reading
	XGL = new QRadioButton(tr("&XGL:"));
		groupie->addButton(XGL);
		groupie->setId(XGL, 1);
		if (!(gl->getXGLPresent())) {
			XGL->setEnabled(false);
		}
		if (gl->getXGLEnabled()) {
			XGL->setChecked(true);
		}

	// ditto, but for AIGLX
	AIGLX = new QRadioButton(tr("&AIGLX:"));
		groupie->addButton(AIGLX);
		groupie->setId(AIGLX, 2);
		if (!(gl->getAIGLXPresent())) {
			AIGLX->setEnabled(false);
		}
		if (gl->getAIGLXEnabled()) {
			AIGLX->setChecked(true);
		}

	// ditto, but for NVidia
	NVidia = new QRadioButton(tr("&NVidia:"));
		groupie->addButton(NVidia);
		groupie->setId(NVidia, 3);
		if (!(gl->getNVidiaPresent())) {
			NVidia->setEnabled(false);
		}
		if (gl->getNVidiaEnabled()) {
			NVidia->setChecked(true);
 		}

	// makes the button that brings the whole world crashing down... jk
	close = new QPushButton(tr("close"));
	saveButton = new QPushButton(tr("save"));

	// makes the layout: three checkboxes down and a pushbutton
	QVBoxLayout *layout = new QVBoxLayout;
		layout->addWidget(none);
		layout->addWidget(XGL);
		layout->addWidget(AIGLX);
		layout->addWidget(NVidia);
		layout->addWidget(saveButton);
		layout->addWidget(close);
		widget->setLayout(layout);
		setWindowTitle(tr("Desktop Acceleration Manager"));

	//connects close to the close() function
	connect(close, SIGNAL(clicked()), this, SLOT(leave()));
	connect(close, SIGNAL(clicked()), this, SLOT(close()));
	connect(saveButton, SIGNAL(clicked()), this, SLOT(save()));
}

void AccelManagerGUI::writeSettings() {
	// this is called in the event of closure, expected or otherwise
	int buttonId = groupie->checkedId();
	if (buttonId != gl->getCurrentAccel()) {
		switch (gl->getCurrentAccel()) {
			case 0: gl->disableAcceleration(); break;
			case 1: gl->setXGLEnabled(false); break;
			case 2: gl->setAIGLXEnabled(false); break;
			case 3: gl->setNVidiaEnabled(false); break;
		}
		switch (buttonId) {
			case 0: gl->disableAcceleration(); break;
			case 1: gl->setXGLEnabled(true); break;
			case 2: gl->setAIGLXEnabled(true); break;
			case 3: gl->setNVidiaEnabled(true); break;
		}
	}
	gl->setCurrentAccel(buttonId);
}

void AccelManagerGUI::save() {
	cout << "Saving..." << endl;
	writeSettings();
}

void AccelManagerGUI::leave() {
	int answer = QMessageBox::warning(this, tr("restart X?"), tr("Do you want to restart the X server?\n Your settings will not take effect until you do."), QMessageBox::Yes | QMessageBox::Default, QMessageBox::No);
	if (answer == QMessageBox::Yes) {
		restartX();
	}
}

void AccelManagerGUI::restartX() {
	system("/etc/init.d/xdm restart");
}