#include <string>
namespace luxrays { namespace ocl {
std::string KernelSource_epsilon_funcs = 
"#line 2 \"epsilon_funcs.cl\"\n"
"\n"
"/***************************************************************************\n"
" *   Copyright (C) 1998-2013 by authors (see AUTHORS.txt)                  *\n"
" *                                                                         *\n"
" *   This file is part of LuxRays.                                         *\n"
" *                                                                         *\n"
" *   LuxRays is free software; you can redistribute it and/or modify       *\n"
" *   it under the terms of the GNU General Public License as published by  *\n"
" *   the Free Software Foundation; either version 3 of the License, or     *\n"
" *   (at your option) any later version.                                   *\n"
" *                                                                         *\n"
" *   LuxRays is distributed in the hope that it will be useful,            *\n"
" *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
" *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
" *   GNU General Public License for more details.                          *\n"
" *                                                                         *\n"
" *   You should have received a copy of the GNU General Public License     *\n"
" *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *\n"
" *                                                                         *\n"
" *   LuxRays website: http://www.luxrender.net                             *\n"
" ***************************************************************************/\n"
"\n"
"float MachineEpsilon_FloatAdvance(const float value) {\n"
"	return as_float(as_uint(value) + DEFAULT_EPSILON_DISTANCE_FROM_VALUE);\n"
"}\n"
"\n"
"float MachineEpsilon_E(const float value) {\n"
"	const float epsilon = fabs(MachineEpsilon_FloatAdvance(value) - value);\n"
"\n"
"	return clamp(epsilon, PARAM_RAY_EPSILON_MIN, PARAM_RAY_EPSILON_MAX);\n"
"}\n"
"\n"
"float MachineEpsilon_E_Float3(const float3 v) {\n"
"	return fmax(MachineEpsilon_E(v.x), fmax(MachineEpsilon_E(v.y), MachineEpsilon_E(v.z)));\n"
"}\n"
; } }
