#include <string>
namespace luxrays { namespace ocl {
std::string KernelSource_epsilon_types = 
"#line 2 \"epsilon_types.cl\"\n"
"\n"
"/***************************************************************************\n"
" *   Copyright (C) 1998-2013 by authors (see AUTHORS.txt)                  *\n"
" *                                                                         *\n"
" *   This file is part of LuxRays.                                         *\n"
" *                                                                         *\n"
" *   LuxRays is free software; you can redistribute it and/or modify       *\n"
" *   it under the terms of the GNU General Public License as published by  *\n"
" *   the Free Software Foundation; either version 3 of the License, or     *\n"
" *   (at your option) any later version.                                   *\n"
" *                                                                         *\n"
" *   LuxRays is distributed in the hope that it will be useful,            *\n"
" *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
" *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
" *   GNU General Public License for more details.                          *\n"
" *                                                                         *\n"
" *   You should have received a copy of the GNU General Public License     *\n"
" *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *\n"
" *                                                                         *\n"
" *   LuxRays website: http://www.luxrender.net                             *\n"
" ***************************************************************************/\n"
"\n"
"// NOTE: DEFAULT_EPSILON_MIN is very small. A plane passing exactly for the\n"
"// origin will suffer of self shadow problems because the Ray class will use\n"
"// MachineEpsilon(ray.o) as epsilon for the ray.mint. However it is pretty much\n"
"// the only case where there is a problem so better to not change anything.\n"
"// As workaround, moving the plane away from the origin is enough.\n"
"#define DEFAULT_EPSILON_MIN 1e-9f\n"
"#define DEFAULT_EPSILON_MAX 1e-1f\n"
"#define DEFAULT_EPSILON_STATIC 1e-5f\n"
"\n"
"// An epsilon that can be used as threshold for cos(theta). For instance:\n"
"// if (Dot(N, LightDir) < DEFAULT_COS_EPSILON_STATIC) return Spectrum();\n"
"#define DEFAULT_COS_EPSILON_STATIC 1e-4f\n"
"\n"
"// This is about 1e-5f for values near 1.f\n"
"#define DEFAULT_EPSILON_DISTANCE_FROM_VALUE 0x80u\n"
; } }
