#include <string>
namespace slg { namespace ocl {
std::string KernelSource_sampler_types = 
"#line 2 \"sampler_types.cl\"\n"
"\n"
"/***************************************************************************\n"
" *   Copyright (C) 1998-2013 by authors (see AUTHORS.txt)                  *\n"
" *                                                                         *\n"
" *   This file is part of LuxRays.                                         *\n"
" *                                                                         *\n"
" *   LuxRays is free software; you can redistribute it and/or modify       *\n"
" *   it under the terms of the GNU General Public License as published by  *\n"
" *   the Free Software Foundation; either version 3 of the License, or     *\n"
" *   (at your option) any later version.                                   *\n"
" *                                                                         *\n"
" *   LuxRays is distributed in the hope that it will be useful,            *\n"
" *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *\n"
" *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *\n"
" *   GNU General Public License for more details.                          *\n"
" *                                                                         *\n"
" *   You should have received a copy of the GNU General Public License     *\n"
" *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *\n"
" *                                                                         *\n"
" *   LuxRays website: http://www.luxrender.net                             *\n"
" ***************************************************************************/\n"
"\n"
"//------------------------------------------------------------------------------\n"
"// Indices of Sample related u[] array\n"
"//------------------------------------------------------------------------------\n"
"\n"
"#if defined(SLG_OPENCL_KERNEL)\n"
"\n"
"#define IDX_SCREEN_X 0\n"
"#define IDX_SCREEN_Y 1\n"
"#if defined(PARAM_CAMERA_HAS_DOF) && defined(PARAM_HAS_PASSTHROUGH)\n"
"#define IDX_EYE_PASSTHROUGH 2\n"
"#define IDX_DOF_X 3\n"
"#define IDX_DOF_Y 4\n"
"#define IDX_BSDF_OFFSET 5\n"
"#elif defined(PARAM_CAMERA_HAS_DOF)\n"
"#define IDX_DOF_X 2\n"
"#define IDX_DOF_Y 3\n"
"#define IDX_BSDF_OFFSET 4\n"
"#elif defined(PARAM_HAS_PASSTHROUGH)\n"
"#define IDX_EYE_PASSTHROUGH 2\n"
"#define IDX_BSDF_OFFSET 3\n"
"#else\n"
"#define IDX_BSDF_OFFSET 2\n"
"#endif\n"
"\n"
"// Relative to IDX_BSDF_OFFSET + PathDepth * VERTEX_SAMPLE_SIZE\n"
"#if defined(PARAM_DIRECT_LIGHT_SAMPLING) && defined(PARAM_HAS_PASSTHROUGH)\n"
"\n"
"#define IDX_PASSTHROUGH 0\n"
"#define IDX_BSDF_X 1\n"
"#define IDX_BSDF_Y 2\n"
"#define IDX_DIRECTLIGHT_X 3\n"
"#define IDX_DIRECTLIGHT_Y 4\n"
"#define IDX_DIRECTLIGHT_Z 5\n"
"#define IDX_DIRECTLIGHT_W 6\n"
"#define IDX_DIRECTLIGHT_A 7\n"
"#define IDX_RR 8\n"
"\n"
"#define VERTEX_SAMPLE_SIZE 9\n"
"\n"
"#elif defined(PARAM_DIRECT_LIGHT_SAMPLING)\n"
"\n"
"#define IDX_BSDF_X 0\n"
"#define IDX_BSDF_Y 1\n"
"#define IDX_DIRECTLIGHT_X 2\n"
"#define IDX_DIRECTLIGHT_Y 3\n"
"#define IDX_DIRECTLIGHT_Z 4\n"
"#define IDX_DIRECTLIGHT_W 5\n"
"#define IDX_RR 6\n"
"\n"
"#define VERTEX_SAMPLE_SIZE 7\n"
"\n"
"#elif defined(PARAM_HAS_PASSTHROUGH)\n"
"\n"
"#define IDX_PASSTHROUGH 0\n"
"#define IDX_BSDF_X 1\n"
"#define IDX_BSDF_Y 2\n"
"#define IDX_RR 3\n"
"\n"
"#define VERTEX_SAMPLE_SIZE 4\n"
"\n"
"#else\n"
"\n"
"#define IDX_BSDF_X 0\n"
"#define IDX_BSDF_Y 1\n"
"#define IDX_RR 2\n"
"\n"
"#define VERTEX_SAMPLE_SIZE 3\n"
"\n"
"#endif\n"
"\n"
"#if (PARAM_SAMPLER_TYPE == 0) || (PARAM_SAMPLER_TYPE == 2)\n"
"#define TOTAL_U_SIZE 2\n"
"#endif\n"
"\n"
"#if (PARAM_SAMPLER_TYPE == 1)\n"
"#define TOTAL_U_SIZE (IDX_BSDF_OFFSET + PARAM_MAX_PATH_DEPTH * VERTEX_SAMPLE_SIZE)\n"
"#endif\n"
"\n"
"#endif\n"
"\n"
"//------------------------------------------------------------------------------\n"
"// Sample data types\n"
"//------------------------------------------------------------------------------\n"
"\n"
"// This is defined only under OpenCL because of variable size structures\n"
"#if defined(SLG_OPENCL_KERNEL)\n"
"\n"
"typedef struct {\n"
"	Spectrum radiance;\n"
"#if defined(PARAM_ENABLE_ALPHA_CHANNEL)\n"
"	float alpha;\n"
"#endif\n"
"} RandomSample;\n"
"\n"
"typedef struct {\n"
"	Spectrum radiance;\n"
"	float alpha;\n"
"\n"
"	float totalI;\n"
"\n"
"	// Using ushort here totally freeze the ATI driver\n"
"	unsigned int largeMutationCount, smallMutationCount;\n"
"	unsigned int current, proposed, consecutiveRejects;\n"
"\n"
"	float weight;\n"
"	Spectrum currentRadiance;\n"
"#if defined(PARAM_ENABLE_ALPHA_CHANNEL)\n"
"	float currentAlpha;\n"
"#endif\n"
"} MetropolisSample;\n"
"\n"
"typedef struct {\n"
"	float rng0, rng1;\n"
"	unsigned int pixelIndex, pass;\n"
"\n"
"	Spectrum radiance;\n"
"#if defined(PARAM_ENABLE_ALPHA_CHANNEL)\n"
"	float alpha;\n"
"#endif\n"
"} SobolSample;\n"
"\n"
"#if (PARAM_SAMPLER_TYPE == 0)\n"
"typedef RandomSample Sample;\n"
"#endif\n"
"\n"
"#if (PARAM_SAMPLER_TYPE == 1)\n"
"typedef MetropolisSample Sample;\n"
"#endif\n"
"\n"
"#if (PARAM_SAMPLER_TYPE == 2)\n"
"typedef SobolSample Sample;\n"
"#endif\n"
"\n"
"#endif\n"
"\n"
"//------------------------------------------------------------------------------\n"
"// Sampler data types\n"
"//------------------------------------------------------------------------------\n"
"\n"
"typedef enum {\n"
"	RANDOM = 0,\n"
"	METROPOLIS = 1,\n"
"	SOBOL = 2\n"
"} SamplerType;\n"
"\n"
"typedef struct {\n"
"	SamplerType type;\n"
"	union {\n"
"		struct {\n"
"			float largeMutationProbability, imageMutationRange;\n"
"			unsigned int maxRejects;\n"
"		} metropolis;\n"
"	};\n"
"} Sampler;\n"
"\n"
"#define SOBOL_BITS 32\n"
"#define SOBOL_MAX_DIMENSIONS 21201\n"
; } }
