/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf;

import com.jtattoo.plaf.AbstractLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class BasePopupMenuUI
extends BasicPopupMenuUI {
    private static Robot robot = null;
    private BufferedImage screenImage = null;
    private MyPopupMenuListener myPopupListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasePopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setOpaque(false);
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        jComponent.setOpaque(true);
    }

    public void installListeners() {
        super.installListeners();
        if (!this.isMenuOpaque()) {
            this.myPopupListener = new MyPopupMenuListener(this);
            this.popupMenu.addPopupMenuListener(this.myPopupListener);
        }
    }

    public void uninstallListeners() {
        if (!this.isMenuOpaque()) {
            this.popupMenu.removePopupMenuListener(this.myPopupListener);
        }
        super.uninstallListeners();
    }

    private boolean isMenuOpaque() {
        return AbstractLookAndFeel.getTheme().isMenuOpaque() || this.getRobot() == null;
    }

    private Robot getRobot() {
        if (robot == null) {
            try {
                robot = new Robot();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return robot;
    }

    public Popup getPopup(JPopupMenu jPopupMenu, int n, int n2) {
        if (!this.isMenuOpaque()) {
            try {
                Dimension dimension = jPopupMenu.getPreferredSize();
                Rectangle rectangle = new Rectangle(n, n2, dimension.width, dimension.height);
                this.screenImage = this.getRobot().createScreenCapture(rectangle);
            }
            catch (Exception exception) {
                this.screenImage = null;
            }
        }
        return super.getPopup(jPopupMenu, n, n2);
    }

    private void resetScreenImage() {
        this.screenImage = null;
    }

    public void update(Graphics graphics, JComponent jComponent) {
        if (this.screenImage != null) {
            graphics.drawImage(this.screenImage, 0, 0, null);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    private static class MyPopupMenuListener
    implements PopupMenuListener {
        private BasePopupMenuUI popupMenuUI = null;

        public MyPopupMenuListener(BasePopupMenuUI basePopupMenuUI) {
            this.popupMenuUI = basePopupMenuUI;
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            if (this.popupMenuUI.screenImage != null) {
                JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
                JRootPane jRootPane = jPopupMenu.getRootPane();
                Point point = jPopupMenu.getLocationOnScreen();
                Point point2 = jRootPane.getLocationOnScreen();
                Graphics graphics = jPopupMenu.getRootPane().getGraphics();
                graphics.drawImage(this.popupMenuUI.screenImage, point.x - point2.x, point.y - point2.y, null);
                this.popupMenuUI.resetScreenImage();
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        }
    }
}

