/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.smart;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseTabbedPaneUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class SmartTabbedPaneUI
extends BaseTabbedPaneUI {
    private static final Color[] SELECTED_TAB_COLORS = new Color[]{AbstractLookAndFeel.getBackgroundColor()};

    public static ComponentUI createUI(JComponent jComponent) {
        return new SmartTabbedPaneUI();
    }

    public void installDefaults() {
        super.installDefaults();
        this.tabAreaInsets = new Insets(2, 6, 2, 6);
        this.contentBorderInsets = new Insets(1, 1, 0, 0);
    }

    protected Font getTabFont(boolean bl) {
        if (bl) {
            return super.getTabFont(bl).deriveFont(1);
        }
        return super.getTabFont(bl);
    }

    protected Color[] getTabColors(int n, boolean bl) {
        if (bl) {
            return SELECTED_TAB_COLORS;
        }
        return super.getTabColors(n, bl);
    }

    protected Color getGapColor(int n) {
        if (n == this.tabPane.getSelectedIndex()) {
            return AbstractLookAndFeel.getBackgroundColor();
        }
        return super.getGapColor(n);
    }

    protected void paintContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabAreaBackground);
        int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
        int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
        if (n == 1 || n == 2) {
            graphics.fillRect(n3, n4, n8, n7);
        } else if (n == 3) {
            graphics.fillRect(n3, n6 - n7 + 1, n5, n7);
        } else {
            graphics.fillRect(n5 - n8 + 1, n4, n8, n6);
        }
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        graphics.setColor(colorUIResource);
        switch (n) {
            case 1: {
                graphics.drawRect(n3, n4 + n7 - 1, n3 + n5 - 1, n6 - n7);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + n7, n5 - 2, n4 + n7);
                graphics.drawLine(n3 + 1, n4 + n7, n3 + 1, n6 - 2);
                break;
            }
            case 2: {
                graphics.drawRect(n3 + n8 - 1, n4, n5 - n8, n4 + n6 - 1);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + n8, n4 + 1, n3 + n8, n6 - 2);
                graphics.drawLine(n3 + n8, n4 + 1, n5 - 2, n4 + 1);
                break;
            }
            case 3: {
                graphics.drawRect(n3, n4, n3 + n5 - 1, n6 - n7);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + 1, n5 - 2, n4 + 1);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n6 - n7 - 1);
                break;
            }
            case 4: {
                graphics.drawRect(n3, n4, n5 - n8, n4 + n6 - 1);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n6 - 2);
                graphics.drawLine(n3 + 1, n4 + 1, n5 - n8 - 1, n4 + 1);
            }
        }
    }

    protected void paintScrollContentBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(AbstractLookAndFeel.getTabAreaBackgroundColor());
        int n7 = this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
        int n8 = this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
        if (n == 1 || n == 2) {
            graphics.fillRect(n3, n4, n8, n7);
        } else if (n == 3) {
            graphics.fillRect(n3, n6 - n7 + 1, n5, n7);
        } else {
            graphics.fillRect(n5 - n8 + 1, n4, n8, n6);
        }
        Insets insets = this.tabPane.getBorder().getBorderInsets(this.tabPane);
        ColorUIResource colorUIResource = AbstractLookAndFeel.getControlDarkShadow();
        ColorUIResource colorUIResource2 = AbstractLookAndFeel.getControlHighlight();
        graphics.setColor(colorUIResource);
        switch (n) {
            case 1: {
                graphics.drawLine(n3, n4 + n7 - 1 - insets.top, n5, n4 + n7 - 1 - insets.top);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3, n4 + n7 - insets.top, n5 - 1, n4 + n7 - insets.top);
                break;
            }
            case 2: {
                graphics.drawLine(n3 + n8 - 1 - insets.left, n4, n3 + n8 - 1 - insets.left, n6);
                graphics.setColor(colorUIResource2);
                graphics.drawLine(n3 + n8 - insets.left, n4, n3 + n8 - insets.left, n6);
                break;
            }
            case 3: {
                graphics.drawLine(n3, n6 - n7 + insets.bottom, n5, n6 - n7 + insets.bottom);
                break;
            }
            case 4: {
                graphics.drawLine(n5 - n8 + insets.right, n4, n5 - n8 + insets.right, n6);
            }
        }
    }

    protected void paintTabBackground(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        if (bl) {
            if (this.tabPane.getBackgroundAt(n2) instanceof UIResource) {
                graphics.setColor(AbstractLookAndFeel.getBackgroundColor());
            } else {
                graphics.setColor(this.tabPane.getBackgroundAt(n2));
            }
            if (n == 1) {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 + 2);
            } else if (n == 2) {
                graphics.fillRect(n3 + 1, n4 + 1, n5 + 2, n6 - 1);
            } else if (n == 3) {
                graphics.fillRect(n3 + 1, n4 - 2, n5 - 1, n6 + 1);
            } else {
                graphics.fillRect(n3 - 2, n4 + 1, n5 + 2, n6 - 1);
            }
        } else {
            super.paintTabBackground(graphics, n, n2, n3, n4, n5, n6, bl);
            switch (n) {
                case 1: {
                    if (n2 != this.rolloverIndex) break;
                    graphics.setColor(AbstractLookAndFeel.getFocusColor());
                    graphics.fillRect(n3 + 2, n4 + 1, n5 - 3, 2);
                    break;
                }
                case 2: {
                    if (n2 != this.rolloverIndex) break;
                    graphics.setColor(AbstractLookAndFeel.getFocusColor());
                    graphics.fillRect(n3, n4 + 2, n5 - 1, 2);
                    break;
                }
                case 4: {
                    if (n2 != this.rolloverIndex) break;
                    graphics.setColor(AbstractLookAndFeel.getFocusColor());
                    graphics.fillRect(n3, n4 + 2, n5 - 1, 2);
                    break;
                }
                case 3: {
                    if (n2 != this.rolloverIndex) break;
                    graphics.setColor(AbstractLookAndFeel.getFocusColor());
                    graphics.fillRect(n3 + 2, n4 + n6 - 3, n5 - 3, 2);
                }
            }
        }
    }
}

