/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.pushingpixels.substance.api.ComponentStateFacet;

public final class ComponentState {
    private static Set<ComponentState> allStates = new HashSet<ComponentState>();
    public static final ComponentState DISABLED_DEFAULT = new ComponentState("disabled default", new ComponentStateFacet[]{ComponentStateFacet.DEFAULT}, new ComponentStateFacet[]{ComponentStateFacet.ENABLE});
    public static final ComponentState DEFAULT = new ComponentState("default", new ComponentStateFacet[]{ComponentStateFacet.DEFAULT, ComponentStateFacet.ENABLE}, null);
    public static final ComponentState DISABLED_SELECTED = new ComponentState("disabled selected", new ComponentStateFacet[]{ComponentStateFacet.SELECTION}, new ComponentStateFacet[]{ComponentStateFacet.ENABLE});
    public static final ComponentState DISABLED_UNSELECTED = new ComponentState("disabled unselected", null, new ComponentStateFacet[]{ComponentStateFacet.ENABLE, ComponentStateFacet.SELECTION});
    public static final ComponentState PRESSED_SELECTED = new ComponentState("pressed selected", new ComponentStateFacet[]{ComponentStateFacet.SELECTION, ComponentStateFacet.PRESS, ComponentStateFacet.ENABLE}, null);
    public static final ComponentState PRESSED_UNSELECTED = new ComponentState("pressed unselected", new ComponentStateFacet[]{ComponentStateFacet.PRESS, ComponentStateFacet.ENABLE}, new ComponentStateFacet[]{ComponentStateFacet.SELECTION});
    public static final ComponentState SELECTED = new ComponentState("selected", new ComponentStateFacet[]{ComponentStateFacet.SELECTION, ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ROLLOVER_SELECTED = new ComponentState("rollover selected", new ComponentStateFacet[]{ComponentStateFacet.SELECTION, ComponentStateFacet.ROLLOVER, ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ARMED = new ComponentState("armed", new ComponentStateFacet[]{ComponentStateFacet.ARM, ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ROLLOVER_ARMED = new ComponentState("rollover armed", new ComponentStateFacet[]{ComponentStateFacet.ROLLOVER, ComponentStateFacet.ARM, ComponentStateFacet.ENABLE}, null);
    public static final ComponentState ROLLOVER_UNSELECTED = new ComponentState("rollover unselected", new ComponentStateFacet[]{ComponentStateFacet.ROLLOVER, ComponentStateFacet.ENABLE}, new ComponentStateFacet[]{ComponentStateFacet.SELECTION});
    public static final ComponentState ENABLED = new ComponentState("enabled", new ComponentStateFacet[]{ComponentStateFacet.ENABLE}, null);
    private Set<ComponentStateFacet> facetsTurnedOn;
    private Set<ComponentStateFacet> facetsTurnedOff;
    private Map<ComponentStateFacet, Boolean> mapping;
    private String name;
    private ComponentState hardFallback;

    public ComponentState(String string, ComponentStateFacet[] componentStateFacetArray, ComponentStateFacet[] componentStateFacetArray2) {
        this(string, null, componentStateFacetArray, componentStateFacetArray2);
    }

    public ComponentState(String string, ComponentState componentState, ComponentStateFacet[] componentStateFacetArray, ComponentStateFacet[] componentStateFacetArray2) {
        if (string == null) {
            throw new IllegalArgumentException("Component state name must be non-null");
        }
        this.name = string;
        this.hardFallback = componentState;
        this.facetsTurnedOn = new HashSet<ComponentStateFacet>();
        if (componentStateFacetArray != null) {
            for (ComponentStateFacet componentStateFacet : componentStateFacetArray) {
                this.facetsTurnedOn.add(componentStateFacet);
            }
        }
        this.facetsTurnedOff = new HashSet<ComponentStateFacet>();
        if (componentStateFacetArray2 != null) {
            for (ComponentStateFacet componentStateFacet : componentStateFacetArray2) {
                this.facetsTurnedOff.add(componentStateFacet);
            }
        }
        this.mapping = new HashMap<ComponentStateFacet, Boolean>();
        allStates.add(this);
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(" : on {");
        if (this.facetsTurnedOn != null) {
            string = "";
            for (ComponentStateFacet componentStateFacet : this.facetsTurnedOn) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(componentStateFacet.toString());
            }
        }
        stringBuffer.append("} : off {");
        if (this.facetsTurnedOff != null) {
            string = "";
            for (ComponentStateFacet componentStateFacet : this.facetsTurnedOff) {
                stringBuffer.append(string);
                string = ", ";
                stringBuffer.append(componentStateFacet.toString());
            }
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public boolean isFacetActive(ComponentStateFacet componentStateFacet) {
        Boolean bl = this.mapping.get(componentStateFacet);
        if (bl != null) {
            return bl;
        }
        if (this.facetsTurnedOn != null && this.facetsTurnedOn.contains(componentStateFacet)) {
            this.mapping.put(componentStateFacet, Boolean.TRUE);
            return true;
        }
        this.mapping.put(componentStateFacet, Boolean.FALSE);
        return false;
    }

    public boolean isDisabled() {
        return !this.isFacetActive(ComponentStateFacet.ENABLE);
    }

    public static ComponentState[] getActiveStates() {
        LinkedList<ComponentState> linkedList = new LinkedList<ComponentState>();
        for (ComponentState componentState : allStates) {
            if (!componentState.isActive()) continue;
            linkedList.add(componentState);
        }
        return linkedList.toArray(new ComponentState[0]);
    }

    public static Set<ComponentState> getAllStates() {
        return Collections.synchronizedSet(allStates);
    }

    public boolean isActive() {
        if (this == ENABLED) {
            return false;
        }
        return this.isFacetActive(ComponentStateFacet.ENABLE);
    }

    public static ComponentState getState(ButtonModel buttonModel, JComponent jComponent) {
        return ComponentState.getState(buttonModel, jComponent, false);
    }

    public static ComponentState getState(AbstractButton abstractButton) {
        return ComponentState.getState(abstractButton.getModel(), abstractButton, false);
    }

    public static ComponentState getState(ButtonModel buttonModel, JComponent jComponent, boolean bl) {
        Object object;
        boolean bl2 = buttonModel.isRollover();
        if (jComponent instanceof MenuElement) {
            object = MenuSelectionManager.defaultManager().getSelectedPath();
            for (MenuElement menuElement : object) {
                if (menuElement != jComponent) continue;
                bl2 = true;
                break;
            }
        }
        if (jComponent != null && jComponent instanceof JButton && ((JButton)(object = (JButton)jComponent)).isDefaultButton()) {
            if (buttonModel.isEnabled()) {
                if (((AbstractButton)object).isRolloverEnabled() && ((AbstractButton)object).getModel().isRollover()) {
                    if (buttonModel.isSelected()) {
                        return ROLLOVER_SELECTED;
                    }
                    return ROLLOVER_UNSELECTED;
                }
                if (!buttonModel.isPressed() && !buttonModel.isArmed()) {
                    return DEFAULT;
                }
            } else {
                return DISABLED_DEFAULT;
            }
        }
        boolean bl3 = true;
        if (jComponent instanceof AbstractButton) {
            bl3 = ((AbstractButton)jComponent).isRolloverEnabled();
        }
        if (!buttonModel.isEnabled()) {
            if (buttonModel.isSelected()) {
                return DISABLED_SELECTED;
            }
            return DISABLED_UNSELECTED;
        }
        if (buttonModel.isArmed() && buttonModel.isPressed()) {
            if (buttonModel.isSelected()) {
                return PRESSED_SELECTED;
            }
            return PRESSED_UNSELECTED;
        }
        if (!bl && buttonModel.isSelected()) {
            if ((jComponent == null || bl3) && bl2) {
                return ROLLOVER_SELECTED;
            }
            return SELECTED;
        }
        if (buttonModel.isArmed()) {
            if ((jComponent == null || bl3) && bl2) {
                return ROLLOVER_ARMED;
            }
            return ARMED;
        }
        if ((jComponent == null || bl3) && bl2) {
            return ROLLOVER_UNSELECTED;
        }
        return ENABLED;
    }

    public static ComponentState getState(boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            if (bl3) {
                return DISABLED_SELECTED;
            }
            return DISABLED_UNSELECTED;
        }
        if (bl3) {
            if (bl2) {
                return ROLLOVER_SELECTED;
            }
            return SELECTED;
        }
        if (bl2) {
            return ROLLOVER_UNSELECTED;
        }
        return ENABLED;
    }

    private int fitValue(ComponentState componentState) {
        int n = 0;
        if (this.facetsTurnedOn != null) {
            for (ComponentStateFacet componentStateFacet : this.facetsTurnedOn) {
                if (componentState.facetsTurnedOn == null) {
                    n -= componentStateFacet.value / 2;
                    continue;
                }
                n = componentState.facetsTurnedOn.contains(componentStateFacet) ? (n += componentStateFacet.value) : (n -= componentStateFacet.value / 2);
                if (!componentState.facetsTurnedOff.contains(componentStateFacet)) continue;
                n -= componentStateFacet.value;
            }
        }
        if (this.facetsTurnedOff != null) {
            for (ComponentStateFacet componentStateFacet : this.facetsTurnedOff) {
                if (componentState.facetsTurnedOff == null) {
                    n -= componentStateFacet.value / 2;
                    continue;
                }
                n = componentState.facetsTurnedOff.contains(componentStateFacet) ? (n += componentStateFacet.value) : (n -= componentStateFacet.value / 2);
                if (!componentState.facetsTurnedOn.contains(componentStateFacet)) continue;
                n -= componentStateFacet.value;
            }
        }
        return n;
    }

    public ComponentState bestFit(Collection<ComponentState> collection) {
        ComponentState componentState = null;
        int n = 0;
        for (ComponentState componentState2 : collection) {
            if (this.isActive() != componentState2.isActive()) continue;
            int n2 = componentState2.fitValue(this) + this.fitValue(componentState2);
            if (componentState == null) {
                componentState = componentState2;
                n = n2;
                continue;
            }
            if (n2 <= n) continue;
            componentState = componentState2;
            n = n2;
        }
        if (n > 0) {
            return componentState;
        }
        return null;
    }

    public ComponentState getHardFallback() {
        return this.hardFallback;
    }

    public int hashCode() {
        if (this.facetsTurnedOn.isEmpty() && this.facetsTurnedOff.isEmpty()) {
            return 0;
        }
        if (this.facetsTurnedOn.isEmpty()) {
            boolean bl = true;
            int n = 0;
            for (ComponentStateFacet componentStateFacet : this.facetsTurnedOff) {
                if (bl) {
                    n = ~componentStateFacet.hashCode();
                    bl = false;
                    continue;
                }
                n &= ~componentStateFacet.hashCode();
            }
            return n;
        }
        boolean bl = true;
        int n = 0;
        for (ComponentStateFacet componentStateFacet : this.facetsTurnedOn) {
            if (bl) {
                n = componentStateFacet.hashCode();
                bl = false;
                continue;
            }
            n &= componentStateFacet.hashCode();
        }
        for (ComponentStateFacet componentStateFacet : this.facetsTurnedOff) {
            n &= ~componentStateFacet.hashCode();
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ComponentState)) {
            return false;
        }
        ComponentState componentState = (ComponentState)object;
        if (this.facetsTurnedOn.size() != componentState.facetsTurnedOn.size()) {
            return false;
        }
        if (this.facetsTurnedOff.size() != componentState.facetsTurnedOff.size()) {
            return false;
        }
        if (!this.facetsTurnedOn.containsAll(componentState.facetsTurnedOn)) {
            return false;
        }
        return this.facetsTurnedOff.containsAll(componentState.facetsTurnedOff);
    }
}

