/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api;

import java.awt.Component;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.internal.colorscheme.BlendBiColorScheme;

public class SubstanceColorSchemeBundle {
    protected SubstanceColorScheme activeColorScheme;
    protected SubstanceColorScheme enabledColorScheme;
    protected SubstanceColorScheme disabledColorScheme;
    protected Map<ComponentState, Float> stateAlphaMap;
    protected Map<ComponentState, Float> stateHighlightSchemeAlphaMap;
    protected SubstanceColorScheme pressedScheme;
    protected SubstanceColorScheme disabledSelectedScheme;
    protected SubstanceColorScheme selectedScheme;
    protected SubstanceColorScheme rolloverSelectedScheme;
    protected Map<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>> colorSchemeMap;
    protected Map<ColorSchemeAssociationKind, Map<ComponentState, ComponentState>> bestFillMap;

    public SubstanceColorSchemeBundle(SubstanceColorScheme substanceColorScheme, SubstanceColorScheme substanceColorScheme2, SubstanceColorScheme substanceColorScheme3) {
        this.activeColorScheme = substanceColorScheme;
        this.enabledColorScheme = substanceColorScheme2;
        this.disabledColorScheme = substanceColorScheme3;
        this.stateAlphaMap = new HashMap<ComponentState, Float>();
        this.stateHighlightSchemeAlphaMap = new HashMap<ComponentState, Float>();
        this.colorSchemeMap = new HashMap<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>>();
        for (ColorSchemeAssociationKind colorSchemeAssociationKind : ColorSchemeAssociationKind.values()) {
            this.colorSchemeMap.put(colorSchemeAssociationKind, new HashMap());
        }
        this.bestFillMap = new HashMap<ColorSchemeAssociationKind, Map<ComponentState, ComponentState>>();
        for (ColorSchemeAssociationKind colorSchemeAssociationKind : ColorSchemeAssociationKind.values()) {
            this.bestFillMap.put(colorSchemeAssociationKind, new HashMap());
        }
    }

    public void registerColorScheme(SubstanceColorScheme substanceColorScheme, float f, ComponentState ... componentStateArray) {
        if (componentStateArray != null) {
            for (ComponentState componentState : componentStateArray) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.FILL).put(componentState, substanceColorScheme);
                this.stateAlphaMap.put(componentState, Float.valueOf(f));
            }
        }
    }

    public void registerColorScheme(SubstanceColorScheme substanceColorScheme, ComponentState ... componentStateArray) {
        this.registerColorScheme(substanceColorScheme, 1.0f, componentStateArray);
    }

    public void registerHighlightColorScheme(SubstanceColorScheme substanceColorScheme, ComponentState ... componentStateArray) {
        if (componentStateArray == null || componentStateArray.length == 0) {
            for (ComponentState componentState : ComponentState.getAllStates()) {
                if (this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).containsKey(componentState) || componentState.isDisabled() || componentState == ComponentState.ENABLED) continue;
                this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(componentState, substanceColorScheme);
            }
        } else {
            for (ComponentState componentState : componentStateArray) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(componentState, substanceColorScheme);
            }
        }
    }

    public void registerHighlightColorScheme(SubstanceColorScheme substanceColorScheme, float f, ComponentState ... componentStateArray) {
        if (substanceColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null color scheme");
        }
        if (componentStateArray == null || componentStateArray.length == 0) {
            for (ComponentState componentState : ComponentState.getAllStates()) {
                if (componentState.isDisabled() || componentState == ComponentState.ENABLED) continue;
                if (!this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).containsKey(componentState)) {
                    this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(componentState, substanceColorScheme);
                }
                if (this.stateHighlightSchemeAlphaMap.containsKey(componentState)) continue;
                this.stateHighlightSchemeAlphaMap.put(componentState, Float.valueOf(f));
            }
        } else {
            for (ComponentState componentState : componentStateArray) {
                this.colorSchemeMap.get(ColorSchemeAssociationKind.HIGHLIGHT).put(componentState, substanceColorScheme);
                this.stateHighlightSchemeAlphaMap.put(componentState, Float.valueOf(f));
            }
        }
    }

    public SubstanceColorScheme getColorScheme(ComponentState componentState) {
        Object object;
        SubstanceColorScheme substanceColorScheme = this.colorSchemeMap.get(ColorSchemeAssociationKind.FILL).get(componentState);
        if (substanceColorScheme != null) {
            return substanceColorScheme;
        }
        Map<ComponentState, ComponentState> map = this.bestFillMap.get(ColorSchemeAssociationKind.FILL);
        if (!map.containsKey(componentState)) {
            object = this.colorSchemeMap.get(ColorSchemeAssociationKind.FILL).keySet();
            map.put(componentState, componentState.bestFit((Collection<ComponentState>)object));
        }
        if ((object = map.get(componentState)) != null && (substanceColorScheme = this.colorSchemeMap.get(ColorSchemeAssociationKind.FILL).get(object)) != null) {
            return substanceColorScheme;
        }
        if (componentState.isFacetActive(ComponentStateFacet.PRESS)) {
            if (this.pressedScheme == null) {
                this.pressedScheme = this.activeColorScheme.shade(0.2).saturate(0.1);
            }
            return this.pressedScheme;
        }
        if (componentState == ComponentState.DISABLED_SELECTED) {
            if (this.disabledSelectedScheme == null) {
                this.disabledSelectedScheme = new BlendBiColorScheme(this.activeColorScheme, this.disabledColorScheme, 0.25);
            }
            return this.disabledSelectedScheme;
        }
        if (componentState == ComponentState.SELECTED) {
            if (this.selectedScheme == null) {
                this.selectedScheme = this.activeColorScheme.saturate(0.2);
            }
            return this.selectedScheme;
        }
        if (componentState == ComponentState.ROLLOVER_SELECTED) {
            if (this.rolloverSelectedScheme == null) {
                this.rolloverSelectedScheme = this.activeColorScheme.tint(0.1).saturate(0.1);
            }
            return this.rolloverSelectedScheme;
        }
        ComponentState componentState2 = componentState.getHardFallback();
        if (componentState2 != null) {
            return this.getColorScheme(componentState2);
        }
        if (componentState == ComponentState.ENABLED) {
            return this.enabledColorScheme;
        }
        if (componentState.isDisabled()) {
            return this.disabledColorScheme;
        }
        return this.activeColorScheme;
    }

    public float getHighlightAlpha(Component component, ComponentState componentState) {
        Float f = this.stateHighlightSchemeAlphaMap.get(componentState);
        if (f != null) {
            return f.floatValue();
        }
        return -1.0f;
    }

    public float getAlpha(Component component, ComponentState componentState) {
        Float f = this.stateAlphaMap.get(componentState);
        if (f != null) {
            return f.floatValue();
        }
        return -1.0f;
    }

    public SubstanceColorScheme getActiveColorScheme() {
        return this.activeColorScheme;
    }

    public SubstanceColorScheme getEnabledColorScheme() {
        return this.enabledColorScheme;
    }

    public SubstanceColorScheme getDisabledColorScheme() {
        return this.disabledColorScheme;
    }

    public void registerColorScheme(SubstanceColorScheme substanceColorScheme, ColorSchemeAssociationKind colorSchemeAssociationKind, ComponentState ... componentStateArray) {
        if (substanceColorScheme == null) {
            throw new IllegalArgumentException("Cannot pass null color scheme");
        }
        if (componentStateArray == null || componentStateArray.length == 0) {
            for (ComponentState componentState : ComponentState.getAllStates()) {
                if (this.colorSchemeMap.get(colorSchemeAssociationKind).containsKey(componentState)) continue;
                this.colorSchemeMap.get(colorSchemeAssociationKind).put(componentState, substanceColorScheme);
            }
        } else {
            for (ComponentState componentState : componentStateArray) {
                this.colorSchemeMap.get(colorSchemeAssociationKind).put(componentState, substanceColorScheme);
            }
        }
    }

    public SubstanceColorScheme getColorScheme(ColorSchemeAssociationKind colorSchemeAssociationKind, ComponentState componentState) {
        Object object;
        if (colorSchemeAssociationKind == ColorSchemeAssociationKind.FILL) {
            return this.getColorScheme(componentState);
        }
        SubstanceColorScheme substanceColorScheme = this.colorSchemeMap.get(colorSchemeAssociationKind).get(componentState);
        if (substanceColorScheme != null) {
            return substanceColorScheme;
        }
        Map<ComponentState, ComponentState> map = this.bestFillMap.get(colorSchemeAssociationKind);
        if (!map.containsKey(componentState)) {
            object = this.colorSchemeMap.get(colorSchemeAssociationKind).keySet();
            map.put(componentState, componentState.bestFit((Collection<ComponentState>)object));
        }
        if ((object = map.get(componentState)) != null && (substanceColorScheme = this.colorSchemeMap.get(colorSchemeAssociationKind).get(object)) != null) {
            return substanceColorScheme;
        }
        ColorSchemeAssociationKind colorSchemeAssociationKind2 = colorSchemeAssociationKind.getFallback();
        if (colorSchemeAssociationKind2 == null) {
            return null;
        }
        return this.getColorScheme(colorSchemeAssociationKind2, componentState);
    }

    SubstanceColorSchemeBundle transform(ColorSchemeTransform colorSchemeTransform) {
        SubstanceColorSchemeBundle substanceColorSchemeBundle = new SubstanceColorSchemeBundle(colorSchemeTransform.transform(this.activeColorScheme), colorSchemeTransform.transform(this.enabledColorScheme), colorSchemeTransform.transform(this.disabledColorScheme));
        for (Map.Entry<ColorSchemeAssociationKind, Map<ComponentState, SubstanceColorScheme>> entry : this.colorSchemeMap.entrySet()) {
            for (Map.Entry<ComponentState, SubstanceColorScheme> entry2 : entry.getValue().entrySet()) {
                substanceColorSchemeBundle.colorSchemeMap.get(entry.getKey()).put(entry2.getKey(), colorSchemeTransform.transform(entry2.getValue()));
            }
        }
        if (this.stateAlphaMap != null) {
            substanceColorSchemeBundle.stateAlphaMap = new HashMap<ComponentState, Float>(this.stateAlphaMap);
        }
        if (this.stateHighlightSchemeAlphaMap != null) {
            substanceColorSchemeBundle.stateHighlightSchemeAlphaMap = new HashMap<ComponentState, Float>(this.stateHighlightSchemeAlphaMap);
        }
        return substanceColorSchemeBundle;
    }

    Set<ComponentState> getStatesWithAlpha() {
        HashSet<ComponentState> hashSet = new HashSet<ComponentState>();
        for (Map.Entry<ComponentState, Float> entry : this.stateAlphaMap.entrySet()) {
            if (!(entry.getValue().floatValue() < 1.0f)) continue;
            hashSet.add(entry.getKey());
        }
        return hashSet;
    }
}

