/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Point;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.FractionBasedPainter;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;

public class FractionBasedDecorationPainter
extends FractionBasedPainter
implements SubstanceDecorationPainter {
    private Set<DecorationAreaType> decoratedAreas = new HashSet<DecorationAreaType>();

    public FractionBasedDecorationPainter(String string, float[] fArray, ColorSchemeSingleColorQuery[] colorSchemeSingleColorQueryArray) {
        this(string, fArray, colorSchemeSingleColorQueryArray, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE);
    }

    public FractionBasedDecorationPainter(String string, float[] fArray, ColorSchemeSingleColorQuery[] colorSchemeSingleColorQueryArray, DecorationAreaType ... decorationAreaTypeArray) {
        super(string, fArray, colorSchemeSingleColorQueryArray);
        if (decorationAreaTypeArray != null) {
            for (DecorationAreaType decorationAreaType : decorationAreaTypeArray) {
                this.decoratedAreas.add(decorationAreaType);
            }
        }
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        if (this.decoratedAreas.contains(decorationAreaType)) {
            this.paintDecoratedBackground(graphics2D, component, decorationAreaType, n, n2, substanceSkin.getBackgroundColorScheme(decorationAreaType));
        } else {
            this.paintSolidBackground(graphics2D, component, n, n2, substanceSkin.getBackgroundColorScheme(decorationAreaType));
        }
    }

    private void paintDecoratedBackground(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        Object object;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Color[] colorArray = new Color[this.fractions.length];
        for (int i = 0; i < this.fractions.length; ++i) {
            object = this.colorQueries[i];
            colorArray[i] = object.query(substanceColorScheme);
        }
        Component component2 = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(component, decorationAreaType);
        object = SwingUtilities.convertPoint(component, new Point(0, 0), component2);
        int n3 = ((Point)object).y;
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, component2.getHeight(), this.fractions, colorArray, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D2.setPaint(linearGradientPaint);
        graphics2D2.translate(0, -n3);
        graphics2D2.fillRect(0, 0, n, component2.getHeight());
        graphics2D2.dispose();
    }

    private void paintSolidBackground(Graphics2D graphics2D, Component component, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.fillRect(0, 0, n, n2);
    }
}

