/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.fill;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.fill.SubstanceFillPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class StandardFillPainter
implements SubstanceFillPainter {
    @Override
    public String getDisplayName() {
        return "Standard";
    }

    @Override
    public void paintContourBackground(Graphics graphics, Component component, int n, int n2, Shape shape, boolean bl, SubstanceColorScheme substanceColorScheme, boolean bl2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color color = this.getTopFillColor(substanceColorScheme);
        Color color2 = this.getMidFillColorTop(substanceColorScheme);
        Color color3 = this.getMidFillColorBottom(substanceColorScheme);
        Color color4 = this.getBottomFillColor(substanceColorScheme);
        Color color5 = this.getTopShineColor(substanceColorScheme);
        Color color6 = this.getBottomShineColor(substanceColorScheme);
        LinearGradientPaint linearGradientPaint = new LinearGradientPaint(0.0f, 0.0f, 0.0f, n2, new float[]{0.0f, 0.4999999f, 0.5f, 1.0f}, new Color[]{color, color2, color3, color4}, MultipleGradientPaint.CycleMethod.REPEAT);
        graphics2D.setPaint(linearGradientPaint);
        graphics2D.fill(shape);
        if (bl2 && color5 != null && color6 != null) {
            graphics2D.clip(shape);
            int n3 = (int)((double)n2 / 1.8);
            int n4 = (int)Math.min(12.0, Math.pow(Math.min(n, n2), 0.8) / 4.0);
            if (n4 < 3) {
                n4 = 3;
            }
            BufferedImage bufferedImage = SubstanceCoreUtilities.getBlankImage(n + 2 * n4, n2 + 2 * n4);
            Graphics2D graphics2D2 = (Graphics2D)bufferedImage.getGraphics().create();
            graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D2.setColor(Color.black);
            graphics2D2.translate(n4, n4);
            int n5 = n4 > 5 ? 2 : 1;
            for (int i = 2 * n4 - 1; i > 0; i -= n5) {
                float f = 1.0f - (float)i / (2.0f * (float)n4);
                graphics2D2.setComposite(AlphaComposite.getInstance(2, f));
                graphics2D2.setStroke(new BasicStroke(i));
                graphics2D2.draw(shape);
            }
            graphics2D2.dispose();
            BufferedImage bufferedImage2 = SubstanceCoreUtilities.getBlankImage(n + 2 * n4, n2 + 2 * n4);
            Graphics2D graphics2D3 = (Graphics2D)bufferedImage2.getGraphics();
            Color color7 = new Color(color6.getRed(), color6.getGreen(), color6.getBlue(), 64);
            GradientPaint gradientPaint = new GradientPaint(0.0f, n4, color5, 0.0f, n4 + n3, color7, true);
            graphics2D3.setPaint(gradientPaint);
            graphics2D3.fillRect(0, n4, n + 2 * n4, n4 + n3);
            graphics2D3.setComposite(AlphaComposite.DstOut);
            graphics2D3.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.drawImage(bufferedImage2, 0, 0, n - 1, n3, n4, n4, n4 + n - 1, n4 + n3, null);
            BufferedImage bufferedImage3 = SubstanceCoreUtilities.getBlankImage(n + 2 * n4, n2 + 2 * n4);
            Graphics2D graphics2D4 = (Graphics2D)bufferedImage3.getGraphics();
            graphics2D4.setPaint(new GradientPaint(0.0f, n4, color, 0.0f, n4 + n2 / 2, color2, true));
            graphics2D4.fillRect(n4, n4, n4 + n, n4 + n3);
            graphics2D4.setComposite(AlphaComposite.DstIn);
            graphics2D4.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.drawImage(bufferedImage3, 0, 0, n - 1, n3, n4, n4, n4 + n - 1, n4 + n3, null);
        }
        graphics2D.dispose();
    }

    public Color getTopFillColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getTopFillColor(substanceColorScheme);
    }

    public Color getMidFillColorTop(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getMidFillColor(substanceColorScheme);
    }

    public Color getMidFillColorBottom(SubstanceColorScheme substanceColorScheme) {
        return this.getMidFillColorTop(substanceColorScheme);
    }

    public Color getBottomFillColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getBottomFillColor(substanceColorScheme);
    }

    public Color getTopShineColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getTopShineColor(substanceColorScheme);
    }

    public Color getBottomShineColor(SubstanceColorScheme substanceColorScheme) {
        return SubstanceColorUtilities.getBottomShineColor(substanceColorScheme);
    }
}

