/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.skin;

import java.awt.Color;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ColorSchemeSingleColorQuery;
import org.pushingpixels.substance.api.ColorSchemeTransform;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.ComponentStateFacet;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceColorSchemeBundle;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.border.ClassicBorderPainter;
import org.pushingpixels.substance.api.painter.border.CompositeBorderPainter;
import org.pushingpixels.substance.api.painter.border.DelegateBorderPainter;
import org.pushingpixels.substance.api.painter.border.FractionBasedBorderPainter;
import org.pushingpixels.substance.api.painter.decoration.MatteDecorationPainter;
import org.pushingpixels.substance.api.painter.fill.FractionBasedFillPainter;
import org.pushingpixels.substance.api.painter.highlight.ClassicHighlightPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomLineOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.BottomShadowOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopBezelOverlayPainter;
import org.pushingpixels.substance.api.painter.overlay.TopLineOverlayPainter;
import org.pushingpixels.substance.api.shaper.ClassicButtonShaper;

public class MagellanSkin
extends SubstanceSkin {
    public static final String NAME = "Magellan";
    private BottomLineOverlayPainter toolbarBottomLineOverlayPainter;
    private TopLineOverlayPainter toolbarTopLineOverlayPainter;
    private TopBezelOverlayPainter footerTopBezelOverlayPainter;

    @Override
    public String getDisplayName() {
        return NAME;
    }

    public MagellanSkin() {
        SubstanceSkin.ColorSchemes colorSchemes = SubstanceSkin.getColorSchemes("org/pushingpixels/substance/api/skin/magellan.colorschemes");
        SubstanceColorScheme substanceColorScheme = colorSchemes.get("Magellan Blue Controls Active");
        SubstanceColorScheme substanceColorScheme2 = colorSchemes.get("Magellan Blue Controls Enabled");
        SubstanceColorSchemeBundle substanceColorSchemeBundle = new SubstanceColorSchemeBundle(substanceColorScheme, substanceColorScheme2, substanceColorScheme2);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme2, 0.5f, ComponentState.DISABLED_UNSELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme, 0.5f, ComponentState.DISABLED_SELECTED);
        SubstanceColorScheme substanceColorScheme3 = colorSchemes.get("Magellan Blue Controls Active Border");
        SubstanceColorScheme substanceColorScheme4 = colorSchemes.get("Magellan Blue Controls Enabled Border");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme3, ColorSchemeAssociationKind.BORDER, ComponentState.getActiveStates());
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme3, ColorSchemeAssociationKind.BORDER, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme4, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED, ComponentState.DISABLED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme5 = colorSchemes.get("Magellan Blue Controls Pressed");
        SubstanceColorScheme substanceColorScheme6 = colorSchemes.get("Magellan Blue Controls Pressed Border");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme5, ColorSchemeAssociationKind.FILL, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme6, ColorSchemeAssociationKind.BORDER, ComponentState.PRESSED_SELECTED, ComponentState.PRESSED_UNSELECTED);
        SubstanceColorScheme substanceColorScheme7 = colorSchemes.get("Magellan Green Controls");
        SubstanceColorScheme substanceColorScheme8 = colorSchemes.get("Magellan Green Controls Mark");
        SubstanceColorScheme substanceColorScheme9 = colorSchemes.get("Magellan Green Controls Border");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme7, ColorSchemeAssociationKind.FILL, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme8, ColorSchemeAssociationKind.MARK, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme9, ColorSchemeAssociationKind.BORDER, ComponentState.ROLLOVER_SELECTED, ComponentState.ROLLOVER_UNSELECTED, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        ComponentState componentState = new ComponentState("uneditable", new ComponentStateFacet[]{ComponentStateFacet.ENABLE}, new ComponentStateFacet[]{ComponentStateFacet.EDITABLE});
        SubstanceColorScheme substanceColorScheme10 = colorSchemes.get("Magellan Uneditable Controls");
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme10, ColorSchemeAssociationKind.FILL, componentState);
        substanceColorSchemeBundle.registerColorScheme(substanceColorScheme, ColorSchemeAssociationKind.FILL, ComponentState.SELECTED);
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme7, 0.7f, ComponentState.ROLLOVER_UNSELECTED);
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme7, 0.8f, ComponentState.SELECTED);
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme7, 0.95f, ComponentState.ROLLOVER_SELECTED);
        substanceColorSchemeBundle.registerHighlightColorScheme(substanceColorScheme7, 1.0f, ComponentState.ARMED, ComponentState.ROLLOVER_ARMED);
        SubstanceColorScheme substanceColorScheme11 = colorSchemes.get("Magellan Light Blue Background");
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle, substanceColorScheme11, DecorationAreaType.NONE);
        SubstanceColorScheme substanceColorScheme12 = colorSchemes.get("Magellan Medium Blue Background");
        SubstanceColorScheme substanceColorScheme13 = colorSchemes.get("Magellan Dark Blue Background");
        this.registerAsDecorationArea(substanceColorScheme12, DecorationAreaType.GENERAL, DecorationAreaType.TOOLBAR);
        this.registerAsDecorationArea(substanceColorScheme13, DecorationAreaType.PRIMARY_TITLE_PANE, DecorationAreaType.SECONDARY_TITLE_PANE, DecorationAreaType.HEADER);
        SubstanceColorScheme substanceColorScheme14 = colorSchemes.get("Magellan Light Blue Controls Active");
        SubstanceColorScheme substanceColorScheme15 = colorSchemes.get("Magellan Light Blue Controls Enabled");
        SubstanceColorScheme substanceColorScheme16 = colorSchemes.get("Magellan Light Blue Borders Enabled");
        SubstanceColorSchemeBundle substanceColorSchemeBundle2 = new SubstanceColorSchemeBundle(substanceColorScheme14, substanceColorScheme15, substanceColorScheme15);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme15, 0.5f, ComponentState.DISABLED_UNSELECTED);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme14, 0.5f, ComponentState.DISABLED_SELECTED);
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme16, ColorSchemeAssociationKind.BORDER, ComponentState.ENABLED);
        SubstanceColorScheme substanceColorScheme17 = colorSchemes.get("Magellan Light Blue Separator");
        substanceColorSchemeBundle2.registerColorScheme(substanceColorScheme17, ColorSchemeAssociationKind.SEPARATOR, new ComponentState[0]);
        SubstanceColorScheme substanceColorScheme18 = colorSchemes.get("Magellan Ultralight Blue Background");
        this.registerDecorationAreaSchemeBundle(substanceColorSchemeBundle2, substanceColorScheme18, DecorationAreaType.FOOTER);
        this.addOverlayPainter(BottomShadowOverlayPainter.getInstance(), DecorationAreaType.TOOLBAR);
        this.toolbarBottomLineOverlayPainter = new BottomLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme substanceColorScheme) {
                return substanceColorScheme.getUltraDarkColor();
            }
        });
        this.addOverlayPainter(this.toolbarBottomLineOverlayPainter, DecorationAreaType.TOOLBAR);
        this.toolbarTopLineOverlayPainter = new TopLineOverlayPainter(new ColorSchemeSingleColorQuery(){

            @Override
            public Color query(SubstanceColorScheme substanceColorScheme) {
                Color color = substanceColorScheme.getForegroundColor();
                return new Color(color.getRed(), color.getGreen(), color.getBlue(), 40);
            }
        });
        this.addOverlayPainter(this.toolbarTopLineOverlayPainter, DecorationAreaType.TOOLBAR);
        this.footerTopBezelOverlayPainter = new TopBezelOverlayPainter(ColorSchemeSingleColorQuery.FOREGROUND, ColorSchemeSingleColorQuery.ULTRALIGHT);
        this.addOverlayPainter(this.footerTopBezelOverlayPainter, DecorationAreaType.FOOTER);
        this.setSelectedTabFadeStart(0.2);
        this.setSelectedTabFadeEnd(0.9);
        FractionBasedBorderPainter fractionBasedBorderPainter = new FractionBasedBorderPainter("Magellan Outer", new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.ULTRADARK, ColorSchemeSingleColorQuery.DARK, ColorSchemeSingleColorQuery.DARK});
        DelegateBorderPainter delegateBorderPainter = new DelegateBorderPainter("Magellan Inner", new ClassicBorderPainter(), -1593835521, 0x60FFFFFF, 0x40FFFFFF, new ColorSchemeTransform(){

            @Override
            public SubstanceColorScheme transform(SubstanceColorScheme substanceColorScheme) {
                return substanceColorScheme.tint(0.5);
            }
        });
        this.borderPainter = new CompositeBorderPainter(NAME, fractionBasedBorderPainter, delegateBorderPainter);
        this.fillPainter = new FractionBasedFillPainter(NAME, new float[]{0.0f, 0.5f, 1.0f}, new ColorSchemeSingleColorQuery[]{ColorSchemeSingleColorQuery.EXTRALIGHT, ColorSchemeSingleColorQuery.LIGHT, ColorSchemeSingleColorQuery.MID});
        this.highlightPainter = new ClassicHighlightPainter();
        this.decorationPainter = new MatteDecorationPainter();
        this.buttonShaper = new ClassicButtonShaper();
    }
}

