/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.watermark;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceStripeWatermark
implements SubstanceWatermark {
    private static Image watermarkImage = null;

    @Override
    public void drawWatermarkImage(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (!component.isShowing()) {
            return;
        }
        int n5 = component.getLocationOnScreen().x;
        int n6 = component.getLocationOnScreen().y;
        graphics.drawImage(watermarkImage, n, n2, n + n3, n2 + n4, n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, null);
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin substanceSkin) {
        GraphicsDevice[] graphicsDeviceArray;
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            rectangle = rectangle.union(graphicsConfiguration.getBounds());
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        watermarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
        Graphics2D graphics2D = (Graphics2D)watermarkImage.getGraphics().create();
        boolean bl = this.drawWatermarkImage(substanceSkin, graphics2D, 0, 0, n, n2, false);
        graphics2D.dispose();
        return bl;
    }

    @Override
    public void previewWatermark(Graphics graphics, SubstanceSkin substanceSkin, int n, int n2, int n3, int n4) {
        this.drawWatermarkImage(substanceSkin, (Graphics2D)graphics, n, n2, n3, n4, true);
    }

    private boolean drawWatermarkImage(SubstanceSkin substanceSkin, Graphics2D graphics2D, int n, int n2, int n3, int n4, boolean bl) {
        int n5;
        Color color = null;
        SubstanceColorScheme substanceColorScheme = substanceSkin.getWatermarkColorScheme();
        color = bl ? (substanceColorScheme.isDark() ? Color.lightGray : Color.darkGray) : substanceColorScheme.getWatermarkStampColor();
        graphics2D.setColor(color);
        for (n5 = n2; n5 < n2 + n4; n5 += 2) {
            graphics2D.drawLine(n, n5, n + n3, n5);
        }
        if (bl) {
            graphics2D.setColor(Color.gray);
            for (n5 = n2 + 1; n5 < n2 + n4; n5 += 2) {
                graphics2D.drawLine(n, n5, n + n3, n5);
            }
        }
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Stripes";
    }

    @Override
    public void dispose() {
        watermarkImage = null;
    }
}

