/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.contrib.jgoodies.looks;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.swing.UIManager;
import org.pushingpixels.lafwidget.utils.LookUtils;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.FontSizeHints;
import org.pushingpixels.substance.internal.contrib.jgoodies.looks.common.ShadowPopup;

public final class Options {
    public static final String PLASTIC_NAME = "com.jgoodies.looks.plastic.PlasticLookAndFeel";
    public static final String PLASTIC3D_NAME = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_NAME = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    public static final String JGOODIES_WINDOWS_NAME = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    @Deprecated
    public static final String EXT_WINDOWS_NAME = "com.jgoodies.looks.windows.WindowsLookAndFeel";
    public static final String DEFAULT_LOOK_NAME = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    private static final Map LAF_REPLACEMENTS = new HashMap();
    public static final String MENU_FONT_KEY = "jgoodies.menuFont";
    public static final String CONTROL_FONT_KEY = "jgoodies.controlFont";
    public static final String FONT_SIZE_HINTS_KEY = "jgoodies.fontSizeHints";
    public static final String USE_SYSTEM_FONTS_KEY = "swing.useSystemFontSettings";
    public static final String USE_SYSTEM_FONTS_APP_KEY = "Application.useSystemFontSettings";
    public static final String DEFAULT_ICON_SIZE_KEY = "jgoodies.defaultIconSize";
    public static final String USE_NARROW_BUTTONS_KEY = "jgoodies.useNarrowButtons";
    public static final String TAB_ICONS_ENABLED_KEY = "jgoodies.tabIconsEnabled";
    public static final String POPUP_DROP_SHADOW_ENABLED_KEY = "jgoodies.popupDropShadowEnabled";
    public static final String IS_NARROW_KEY = "jgoodies.isNarrow";
    public static final String IS_ETCHED_KEY = "jgoodies.isEtched";
    public static final String HEADER_STYLE_KEY = "jgoodies.headerStyle";
    public static final String NO_ICONS_KEY = "jgoodies.noIcons";
    public static final String TREE_LINE_STYLE_KEY = "JTree.lineStyle";
    public static final String TREE_LINE_STYLE_ANGLED_VALUE = "Angled";
    public static final String TREE_LINE_STYLE_NONE_VALUE = "None";
    public static final String NO_CONTENT_BORDER_KEY = "jgoodies.noContentBorder";
    public static final String EMBEDDED_TABS_KEY = "jgoodies.embeddedTabs";
    private static final Boolean TAB_ICONS_ENABLED_SYSTEM_VALUE;
    private static final Boolean POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
    private static final Dimension DEFAULT_ICON_SIZE;

    private Options() {
    }

    public static boolean getUseSystemFonts() {
        return UIManager.get(USE_SYSTEM_FONTS_APP_KEY).equals(Boolean.TRUE);
    }

    public static void setUseSystemFonts(boolean bl) {
        UIManager.put(USE_SYSTEM_FONTS_APP_KEY, bl);
    }

    public static Dimension getDefaultIconSize() {
        Dimension dimension = UIManager.getDimension(DEFAULT_ICON_SIZE_KEY);
        return dimension == null ? DEFAULT_ICON_SIZE : dimension;
    }

    public static void setDefaultIconSize(Dimension dimension) {
        UIManager.put(DEFAULT_ICON_SIZE_KEY, dimension);
    }

    public static FontSizeHints getGlobalFontSizeHints() {
        Object object = UIManager.get(FONT_SIZE_HINTS_KEY);
        if (object != null) {
            return (FontSizeHints)object;
        }
        String string = LookUtils.getSystemProperty(FONT_SIZE_HINTS_KEY, "");
        try {
            return FontSizeHints.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return FontSizeHints.DEFAULT;
        }
    }

    public static void setGlobalFontSizeHints(FontSizeHints fontSizeHints) {
        UIManager.put(FONT_SIZE_HINTS_KEY, fontSizeHints);
    }

    public static boolean getUseNarrowButtons() {
        return UIManager.getBoolean(USE_NARROW_BUTTONS_KEY);
    }

    public static void setUseNarrowButtons(boolean bl) {
        UIManager.put(USE_NARROW_BUTTONS_KEY, bl);
    }

    public static boolean isTabIconsEnabled() {
        return TAB_ICONS_ENABLED_SYSTEM_VALUE == null ? !Boolean.FALSE.equals(UIManager.get(TAB_ICONS_ENABLED_KEY)) : TAB_ICONS_ENABLED_SYSTEM_VALUE;
    }

    public static void setTabIconsEnabled(boolean bl) {
        UIManager.put(TAB_ICONS_ENABLED_KEY, bl);
    }

    public static boolean isPopupDropShadowActive() {
        return !LookUtils.getToolkitUsesNativeDropShadows() && ShadowPopup.canSnapshot() && Options.isPopupDropShadowEnabled();
    }

    public static boolean isPopupDropShadowEnabled() {
        if (POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE != null) {
            return POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE;
        }
        Object object = UIManager.get(POPUP_DROP_SHADOW_ENABLED_KEY);
        return object == null ? Options.isPopupDropShadowEnabledDefault() : Boolean.TRUE.equals(object);
    }

    public static void setPopupDropShadowEnabled(boolean bl) {
        UIManager.put(POPUP_DROP_SHADOW_ENABLED_KEY, bl);
    }

    private static boolean isPopupDropShadowEnabledDefault() {
        return LookUtils.IS_OS_WINDOWS_MODERN;
    }

    public static void putLookAndFeelReplacement(String string, String string2) {
        LAF_REPLACEMENTS.put(string, string2);
    }

    public static void removeLookAndFeelReplacement(String string) {
        LAF_REPLACEMENTS.remove(string);
    }

    public static void initializeDefaultReplacements() {
        Options.putLookAndFeelReplacement("javax.swing.plaf.metal.MetalLookAndFeel", "com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
        Options.putLookAndFeelReplacement("com.sun.java.swing.plaf.windows.WindowsLookAndFeel", "com.jgoodies.looks.windows.WindowsLookAndFeel");
    }

    public static String getReplacementClassNameFor(String string) {
        String string2 = (String)LAF_REPLACEMENTS.get(string);
        return string2 == null ? string : string2;
    }

    public static String getCrossPlatformLookAndFeelClassName() {
        return "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    }

    public static String getSystemLookAndFeelClassName() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            return "com.jgoodies.looks.windows.WindowsLookAndFeel";
        }
        if (string.startsWith("Mac")) {
            return UIManager.getSystemLookAndFeelClassName();
        }
        return Options.getCrossPlatformLookAndFeelClassName();
    }

    static {
        Options.initializeDefaultReplacements();
        TAB_ICONS_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty(TAB_ICONS_ENABLED_KEY, "Icons in tabbed panes");
        POPUP_DROP_SHADOW_ENABLED_SYSTEM_VALUE = LookUtils.getBooleanSystemProperty(POPUP_DROP_SHADOW_ENABLED_KEY, "Popup drop shadows");
        DEFAULT_ICON_SIZE = new Dimension(20, 20);
    }
}

