/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.LafWidgetUtilities;
import org.pushingpixels.lafwidget.animation.AnimationConfigurationManager;
import org.pushingpixels.lafwidget.animation.AnimationFacet;
import org.pushingpixels.lafwidget.animation.effects.GhostPaintingUtils;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.animation.ModificationAwareUI;
import org.pushingpixels.substance.internal.animation.RootPaneDefaultButtonTracker;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.ButtonBackgroundDelegate;
import org.pushingpixels.substance.internal.utils.ButtonVisualStateTracker;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;
import org.pushingpixels.substance.internal.utils.icon.GlowingIcon;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.swing.SwingRepaintCallback;

public class SubstanceButtonUI
extends BasicButtonUI
implements TransitionAwareUI,
ModificationAwareUI {
    protected boolean iconGhostingMarker;
    protected Set lafWidgets;
    public static final String BORDER_COMPUTED = "substancelaf.buttonbordercomputed";
    public static final String BORDER_COMPUTING = "substancelaf.buttonbordercomputing";
    public static final String BORDER_ORIGINAL = "substancelaf.buttonborderoriginal";
    public static final String ICON_ORIGINAL = "substancelaf.buttoniconoriginal";
    public static final String OPACITY_ORIGINAL = "substancelaf.buttonopacityoriginal";
    public static final String LOCK_OPACITY = "substancelaf.lockopacity";
    public static final String IS_TITLE_CLOSE_BUTTON = "substancelaf.internal.isTitleCloseButton";
    private ButtonBackgroundDelegate delegate;
    protected GlowingIcon glowingIcon;
    protected PropertyChangeListener substancePropertyListener;
    protected ButtonVisualStateTracker substanceVisualStateTracker;
    protected AbstractButton button;
    private Timeline modifiedTimeline;
    private Rectangle viewRect = new Rectangle();
    private Rectangle iconRect = new Rectangle();
    private Rectangle textRect = new Rectangle();

    @Override
    protected void paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        jComponent.putClientProperty("icon.bounds", new Rectangle(rectangle));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        GhostPaintingUtils.paintGhostIcon(graphics2D, (AbstractButton)jComponent, rectangle);
        graphics2D.dispose();
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__icon__paintIcon(graphics, jComponent, rectangle);
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstanceButtonUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstanceButtonUI((AbstractButton)jComponent);
    }

    public SubstanceButtonUI(AbstractButton abstractButton) {
        this.button = abstractButton;
        this.delegate = new ButtonBackgroundDelegate();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (abstractButton.getClientProperty(BORDER_ORIGINAL) == null) {
            abstractButton.putClientProperty(BORDER_ORIGINAL, abstractButton.getBorder());
        }
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        if (abstractButton.getClientProperty(BORDER_COMPUTED) == null) {
            abstractButton.setBorder(substanceButtonShaper.getButtonBorder(abstractButton));
        } else {
            Border border = abstractButton.getBorder();
            if (!(border instanceof SubstanceButtonBorder)) {
                abstractButton.setBorder(substanceButtonShaper.getButtonBorder(abstractButton));
            } else {
                SubstanceButtonBorder substanceButtonBorder = (SubstanceButtonBorder)border;
                if (substanceButtonShaper.getClass() != substanceButtonBorder.getButtonShaperClass()) {
                    abstractButton.setBorder(substanceButtonShaper.getButtonBorder(abstractButton));
                }
            }
        }
        abstractButton.putClientProperty(OPACITY_ORIGINAL, abstractButton.isOpaque());
        abstractButton.setOpaque(false);
        abstractButton.setRolloverEnabled(true);
        LookAndFeel.installProperty(abstractButton, "iconTextGap", SubstanceSizeUtils.getTextIconGap(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
        if (Boolean.TRUE.equals(abstractButton.getClientProperty("windowModified"))) {
            this.trackModificationFlag();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        abstractButton.setBorder((Border)abstractButton.getClientProperty(BORDER_ORIGINAL));
        abstractButton.setOpaque((Boolean)abstractButton.getClientProperty(OPACITY_ORIGINAL));
        Icon icon = (Icon)abstractButton.getClientProperty(ICON_ORIGINAL);
        if (icon != null) {
            abstractButton.setIcon(icon);
        }
        abstractButton.putClientProperty(OPACITY_ORIGINAL, null);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton abstractButton) {
        return null;
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__installListeners(AbstractButton abstractButton) {
        super.installListeners(abstractButton);
        this.substanceVisualStateTracker = new ButtonVisualStateTracker();
        this.substanceVisualStateTracker.installListeners(abstractButton, true);
        this.trackGlowingIcon();
        this.substancePropertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("icon".equals(propertyChangeEvent.getPropertyName())) {
                    SubstanceButtonUI.this.trackGlowingIcon();
                }
                if ("windowModified".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = (Boolean)propertyChangeEvent.getNewValue();
                    if (bl) {
                        SubstanceButtonUI.this.trackModificationFlag();
                    } else if (SubstanceButtonUI.this.modifiedTimeline != null) {
                        SubstanceButtonUI.this.modifiedTimeline.cancel();
                    }
                }
            }
        };
        abstractButton.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__uninstallListeners(AbstractButton abstractButton) {
        this.substanceVisualStateTracker.uninstallListeners(abstractButton);
        this.substanceVisualStateTracker = null;
        abstractButton.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(abstractButton);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Serializable serializable;
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return;
        }
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (abstractButton instanceof JButton && RootPaneDefaultButtonTracker.isPulsating(serializable = (JButton)abstractButton)) {
            RootPaneDefaultButtonTracker.update(serializable);
        }
        serializable = graphics.getFontMetrics();
        Insets insets = jComponent.getInsets();
        this.viewRect.x = insets.left;
        this.viewRect.y = insets.top;
        this.viewRect.width = abstractButton.getWidth() - (insets.right + this.viewRect.x);
        this.viewRect.height = abstractButton.getHeight() - (insets.bottom + this.viewRect.y);
        this.textRect.height = 0;
        this.textRect.width = 0;
        this.textRect.y = 0;
        this.textRect.x = 0;
        this.iconRect.height = 0;
        this.iconRect.width = 0;
        this.iconRect.y = 0;
        this.iconRect.x = 0;
        Font font = jComponent.getFont();
        String string = SwingUtilities.layoutCompoundLabel(jComponent, (FontMetrics)serializable, abstractButton.getText(), abstractButton.getIcon(), abstractButton.getVerticalAlignment(), abstractButton.getHorizontalAlignment(), abstractButton.getVerticalTextPosition(), abstractButton.getHorizontalTextPosition(), this.viewRect, this.iconRect, this.textRect, abstractButton.getText() == null ? 0 : abstractButton.getIconTextGap());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        View view = (View)jComponent.getClientProperty("html");
        graphics2D.setFont(font);
        this.delegate.updateBackground(graphics2D, abstractButton);
        if (view != null) {
            view.paint(graphics2D, this.textRect);
        } else {
            this.paintButtonText(graphics2D, abstractButton, this.textRect, string);
        }
        if (abstractButton.getIcon() != null) {
            this.paintIcon(graphics2D, jComponent, this.iconRect);
        }
        if (abstractButton.isFocusPainted()) {
            SubstanceCoreUtilities.paintFocus(graphics, abstractButton, abstractButton, this, null, this.textRect, 1.0f, SubstanceSizeUtils.getFocusRingPadding(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        AbstractButton abstractButton = (AbstractButton)jComponent;
        SubstanceButtonShaper substanceButtonShaper = SubstanceCoreUtilities.getButtonShaper(abstractButton);
        Dimension dimension = super.getPreferredSize(abstractButton);
        if (dimension == null) {
            return null;
        }
        if (substanceButtonShaper == null) {
            return dimension;
        }
        Dimension dimension2 = substanceButtonShaper.getPreferredSize(abstractButton, dimension);
        return dimension2;
    }

    @Override
    public boolean contains(JComponent jComponent, int n, int n2) {
        return ButtonBackgroundDelegate.contains((JButton)jComponent, n, n2);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__icon__paintIcon(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        AbstractButton abstractButton = (AbstractButton)jComponent;
        Icon icon = SubstanceCoreUtilities.getOriginalIcon(abstractButton, abstractButton.getIcon());
        Icon icon2 = !(abstractButton instanceof JRadioButton) && !(abstractButton instanceof JCheckBox) && SubstanceCoreUtilities.useThemedDefaultIcon(abstractButton) ? SubstanceCoreUtilities.getThemedIcon(abstractButton, icon) : icon;
        graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite((Component)abstractButton, graphics));
        float f = this.substanceVisualStateTracker.getStateTransitionTracker().getActiveStrength();
        if (f >= 0.0f) {
            if (AnimationConfigurationManager.getInstance().isAnimationAllowed(AnimationFacet.ICON_GLOW, abstractButton) && this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker().isPlaying()) {
                this.glowingIcon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
            } else {
                icon2.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
                graphics2D.setComposite(LafWidgetUtilities.getAlphaComposite(abstractButton, f, graphics));
                icon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
            }
        } else {
            icon.paintIcon(abstractButton, graphics2D, rectangle.x, rectangle.y);
        }
        graphics2D.dispose();
    }

    protected void paintButtonText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        SubstanceTextUtilities.paintText(graphics, abstractButton, rectangle, string, abstractButton.getDisplayedMnemonicIndex());
    }

    protected void trackGlowingIcon() {
        Icon icon = this.button.getIcon();
        if (icon instanceof GlowingIcon) {
            return;
        }
        if (icon == null) {
            return;
        }
        this.glowingIcon = new GlowingIcon(icon, this.substanceVisualStateTracker.getStateTransitionTracker().getIconGlowTracker());
    }

    public void __org__pushingpixels__substance__internal__ui__SubstanceButtonUI__update(Graphics graphics, JComponent jComponent) {
        this.paint(graphics, jComponent);
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        return this.contains(this.button, mouseEvent.getX(), mouseEvent.getY());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.substanceVisualStateTracker.getStateTransitionTracker();
    }

    private void trackModificationFlag() {
        this.modifiedTimeline = new Timeline((Object)this.button);
        AnimationConfigurationManager.getInstance().configureModifiedTimeline(this.modifiedTimeline);
        this.modifiedTimeline.addCallback((TimelineCallback)new SwingRepaintCallback((Component)this.button));
        this.modifiedTimeline.playLoop(Timeline.RepeatBehavior.REVERSE);
    }

    @Override
    public Timeline getModificationTimeline() {
        return this.modifiedTimeline;
    }
}

