/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.utils.scroll;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.pushingpixels.substance.api.ColorSchemeAssociationKind;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.painter.border.StandardBorderPainter;
import org.pushingpixels.substance.internal.painter.SimplisticSoftBorderPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;

public class SubstanceScrollPaneBorder
implements Border,
UIResource {
    @Override
    public Insets getBorderInsets(Component component) {
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        int n = (int)f;
        return new Insets(n, n, n, n);
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        boolean bl;
        if (!(component instanceof JScrollPane)) {
            return;
        }
        JScrollPane jScrollPane = (JScrollPane)component;
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        JScrollBar jScrollBar2 = jScrollPane.getHorizontalScrollBar();
        JViewport jViewport = jScrollPane.getColumnHeader();
        SimplisticSoftBorderPainter simplisticSoftBorderPainter = new SimplisticSoftBorderPainter();
        SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(component, ColorSchemeAssociationKind.BORDER, component.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED);
        float f = SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component));
        int n5 = (int)Math.floor((double)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(component)) / 2.0);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.setStroke(new BasicStroke(f, 2, 0));
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        n += n5;
        n2 += n5;
        n3 -= 2 * n5;
        n4 -= 2 * n5;
        boolean bl2 = jScrollBar2 != null && jScrollBar2.isVisible();
        boolean bl3 = jScrollBar != null && jScrollBar.isVisible();
        boolean bl4 = bl = jScrollPane.getRowHeader() != null;
        if (jScrollPane.getComponentOrientation().isLeftToRight()) {
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getTopBorderColor(substanceColorScheme));
            if (bl3 && jViewport == null) {
                graphics2D.drawLine(n, n2, n + n3 - jScrollBar.getWidth(), n2);
            } else {
                graphics2D.drawLine(n, n2, n + n3, n2);
            }
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getTopBorderColor(substanceColorScheme));
            if (bl2 && !bl) {
                graphics2D.drawLine(n, n2, n, n2 + n4 - jScrollBar2.getHeight());
            } else {
                graphics2D.drawLine(n, n2, n, n2 + n4);
            }
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getBottomBorderColor(substanceColorScheme));
            if (bl2) {
                if (bl) {
                    graphics2D.drawLine(n, n2 + n4 - 1, n + jScrollPane.getRowHeader().getSize().width, n2 + n4 - 1);
                }
            } else if (bl3) {
                graphics2D.drawLine(n, n2 + n4 - 1, n + n3 - jScrollBar.getWidth(), n2 + n4 - 1);
            } else {
                graphics2D.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getBottomBorderColor(substanceColorScheme));
            if (bl3) {
                if (jViewport != null) {
                    graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + jViewport.getHeight());
                }
            } else if (bl2) {
                graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - jScrollBar2.getHeight());
            } else {
                graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            }
        } else {
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getTopBorderColor(substanceColorScheme));
            if (bl3 && jViewport == null) {
                graphics2D.drawLine(n + jScrollBar.getWidth(), n2, n + n3, n2);
            } else {
                graphics2D.drawLine(n, n2, n + n3, n2);
            }
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getBottomBorderColor(substanceColorScheme));
            if (bl3) {
                if (jViewport != null) {
                    graphics2D.drawLine(n, n2, n, n2 + jViewport.getHeight());
                }
            } else if (bl2) {
                graphics2D.drawLine(n, n2, n, n2 + n4 - jScrollBar2.getHeight());
            } else {
                graphics2D.drawLine(n, n2, n, n2 + n4 - 1);
            }
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getBottomBorderColor(substanceColorScheme));
            if (bl2) {
                if (bl) {
                    graphics2D.drawLine(n + n3 - jScrollPane.getRowHeader().getSize().width, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                }
            } else if (bl3) {
                graphics2D.drawLine(n + jScrollBar.getWidth(), n2 + n4 - 1, n + n3, n2 + n4 - 1);
            } else {
                graphics2D.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            }
            graphics2D.setColor(((StandardBorderPainter)simplisticSoftBorderPainter).getTopBorderColor(substanceColorScheme));
            if (bl2 && !bl) {
                graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - jScrollBar2.getHeight());
            } else {
                graphics2D.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4);
            }
        }
        graphics2D.dispose();
    }
}

