/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.application;

import cz.vity.freerapid.swing.Swinger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class GlobalEDTExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private static final Logger logger = Logger.getLogger(GlobalEDTExceptionHandler.class.getName());
    private static Set<String> reported = new HashSet<String>(2);
    private static final Object lock = new Object();
    private static String previousError = "";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread thread, final Throwable throwable) {
        String string;
        if (throwable instanceof IllegalStateException && throwable.getMessage().contains("cannot open system")) {
            return;
        }
        if (throwable instanceof InternalError) {
            logger.log(Level.SEVERE, "Uncaught exception on thread ", throwable);
            Swinger.showErrorDialog("errorMessageBasic", throwable, false);
            return;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        final String string2 = stringWriter.toString();
        Object object = lock;
        synchronized (object) {
            if (previousError != null && previousError.contains(string2)) {
                return;
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            logger.log(Level.SEVERE, "Uncaught exception on EDT. ", throwable);
        } else {
            logger.log(Level.SEVERE, "Uncaught exception on thread " + thread.getName(), throwable);
        }
        printWriter.close();
        if (string2.contains("java.lang.ClassCastException: java.awt.TrayIcon cannot be cast to java.awt.Component")) {
            logger.severe(string2 + "JRE bug - ignoring this exception");
            return;
        }
        if (string2.contains("NoSuchMethodError: java.awt.Rectangle.union")) {
            logger.severe(string2 + "invalid JRE installation - ignoring this exception");
            return;
        }
        boolean bl = reported.contains(string2);
        reported.add(string2);
        if (string2.contains("NoClassDefFoundError: Could not initialize class sun.awt.shell.Win32ShellFolder2") || string2.contains("WinampMoveStyle") || string2.contains("JToolTip cannot be cast to javax.swing.text.JTextComponent") || string2.contains("Connection is not open") || string2.contains("Buffers have not been created") || string2.contains("RejectedExecutionException") || string2.contains("OutOfMemoryError") || string2.contains("Could not get shell folder ID list")) {
            bl = true;
        }
        if (string2.contains("Non-Java exception raised, not handled!")) {
            string = "errorMessageMacOSXBug";
            bl = true;
        } else {
            string = "errorMessageBasic";
        }
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock;
                synchronized (object) {
                    if (previousError != null && previousError.contains(string2)) {
                        return;
                    }
                    Swinger.showErrorDialog(string, throwable, !bl2);
                    previousError = string2;
                }
            }
        });
    }
}

